/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.logview;

import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.Table;
import fr.amapj.common.DateUtils;
import fr.amapj.model.models.param.ChoixOnOff;
import fr.amapj.model.models.saas.TypLog;
import fr.amapj.service.services.appinstance.LogAccessDTO;
import fr.amapj.service.services.logview.LogFileResource;
import fr.amapj.service.services.logview.LogViewDTO;
import fr.amapj.service.services.logview.LogViewService;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.views.logview.ChoixLogLevel;
import fr.amapj.view.views.logview.LogViewEditorPart;
import fr.amapj.view.views.logview.PopupAppTempConfiguration;
import fr.amapj.view.views.logview.TelechargerLogPopup;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;

public class LogView
extends StandardListPart<LogAccessDTO> {
    private LogViewDTO logViewDTO;
    private Label infos;

    public LogView() {
        super(LogAccessDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des logs";
    }

    @Override
    protected void addSelectorComponent() {
        this.logViewDTO = new LogViewDTO();
        this.logViewDTO.dateMin = DateUtils.getDateWithNoTime();
        this.logViewDTO.status = ChoixOnOff.ON;
        this.logViewDTO.typLog = TypLog.USER;
        this.infos = new Label();
        this.infos.setWidth("80%");
        this.updateLabelInfo();
        Button b = new Button("Parametres");
        b.addClickListener((Button.ClickListener & Serializable)e -> this.handleParametres());
        HorizontalLayout hl = new HorizontalLayout();
        hl.setWidth("100%");
        hl.addComponent((Component)this.infos);
        hl.addComponent((Component)b);
        hl.setExpandRatio((Component)this.infos, 1.0f);
        this.addComponent((Component)hl);
    }

    private void updateLabelInfo() {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
        String str = "";
        if (this.logViewDTO.dbName != null && this.logViewDTO.dbName.length() > 0) {
            str = String.valueOf(str) + " Instance=" + this.logViewDTO.dbName;
        }
        if (this.logViewDTO.status != null) {
            str = String.valueOf(str) + " Etat=" + (Object)((Object)this.logViewDTO.status);
        }
        if (this.logViewDTO.typLog != null) {
            str = String.valueOf(str) + " Type=" + (Object)((Object)this.logViewDTO.typLog);
        }
        if (this.logViewDTO.dateMin != null) {
            str = String.valueOf(str) + " DateMin=" + df.format(this.logViewDTO.dateMin);
        }
        if (this.logViewDTO.dateMax != null) {
            str = String.valueOf(str) + " DateMax=" + df.format(this.logViewDTO.dateMax);
        }
        if (this.logViewDTO.nbError > 0) {
            str = String.valueOf(str) + " Erreur>=" + this.logViewDTO.nbError;
        }
        if (this.logViewDTO.nom != null && this.logViewDTO.nom.length() > 0) {
            str = String.valueOf(str) + " Nom Util=" + this.logViewDTO.nom;
        }
        if (this.logViewDTO.ip != null && this.logViewDTO.ip.length() > 0) {
            str = String.valueOf(str) + " Ip=" + this.logViewDTO.ip;
        }
        this.infos.setValue(str);
    }

    @Override
    protected void drawButton() {
        this.addButtonAction("Rafraichir", ButtonType.ALWAYS, () -> this.refreshTable());
        this.addButton("T\u00e9l\u00e9charger", ButtonType.ALWAYS, e -> new TelechargerLogPopup(() -> this.getVisiblesLines()));
        this.addButton("Niveau de log", ButtonType.ALWAYS, e -> new ChoixLogLevel());
        this.addButton("Configuration temporaire", ButtonType.ALWAYS, e -> new PopupAppTempConfiguration());
    }

    @Override
    protected void drawTable() {
        this.addColumn("sudo", "Sudo");
        this.addColumn("nom", "Nom");
        this.addColumn("prenom", "Pr\u00e9nom");
        this.addColumn("dbName", "Base");
        this.addColumn("status", "Etat");
        this.addColumn("typLog", "Type");
        this.addColumn("ip", "Ip");
        this.addColumn("browser", "Browser");
        this.addColumnDateTime("dateIn", "Date connexion");
        this.addColumnDateTime("dateOut", "Date d\u00e9connexion");
        this.addColumn("nbError", "Erreur").center();
        this.addColumnGenerator("t", "T\u00e9l\u00e9charger ...", new Table.ColumnGenerator(){

            public Object generateCell(Table source, Object itemId, Object columnId) {
                LogAccessDTO dto = (LogAccessDTO)itemId;
                if (dto.logFileName == null) {
                    Label l = new Label("Pas de fichier");
                    return l;
                }
                LogFileResource logFileResource = new LogFileResource(dto.logFileName);
                Link extractFile = new Link("T\u00e9l\u00e9charger le fichier de log", (Resource)new StreamResource((StreamResource.StreamSource)logFileResource, String.valueOf(dto.logFileName) + ".log"));
                return extractFile;
            }
        });
    }

    @Override
    protected List<LogAccessDTO> getLines() {
        return new LogViewService().getLogs(this.logViewDTO);
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"dateIn"};
    }

    @Override
    protected boolean[] getSortAsc() {
        return new boolean[1];
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom", "prenom", "dbName"};
    }

    @Override
    public void onPopupClose() {
        super.onPopupClose();
        this.updateLabelInfo();
    }

    private void handleParametres() {
        LogViewEditorPart.open(new LogViewEditorPart(this.logViewDTO), this);
    }
}

