/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.mesadhesions;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Link;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.model.models.cotisation.EtatPaiementAdhesion;
import fr.amapj.model.models.param.paramecran.PEMesAdhesions;
import fr.amapj.service.services.edgenerator.pdf.PGBulletinAdhesion;
import fr.amapj.service.services.mesadhesions.AdhesionDTO;
import fr.amapj.service.services.mesadhesions.MesAdhesionDTO;
import fr.amapj.service.services.mesadhesions.MesAdhesionsService;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.engine.template.FrontOfficeView;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import fr.amapj.view.views.mesadhesions.PopupAdhesion;
import fr.amapj.view.views.mesadhesions.PopupAdhesionVoir;
import java.io.Serializable;
import java.text.SimpleDateFormat;

public class MesAdhesionsView
extends FrontOfficeView
implements PopupListener {
    private static String LABEL_RUBRIQUE = "rubrique";
    private static String LABEL_TITRECONTRAT = "titrecontrat";
    private static String PANEL_UNCONTRAT = "uncontrat";
    private static String BUTTON_PRINCIPAL = "principal";

    @Override
    public String getMainStyleName() {
        return "mesadhesions";
    }

    @Override
    public void enter() {
        this.removeAllComponents();
        MesAdhesionDTO mesAdhesionsDTO = new MesAdhesionsService().computeAdhesionInfo(SessionManager.getUserId());
        if (mesAdhesionsDTO.nouvelles.size() > 0) {
            this.addLabel(this, "Renouvellement de votre adh\u00e9sion \u00e0 l'AMAP", LABEL_RUBRIQUE);
            for (AdhesionDTO adhesionDTO : mesAdhesionsDTO.nouvelles) {
                this.displayAdhesion(adhesionDTO, true);
            }
        }
        if (mesAdhesionsDTO.enCours.size() > 0) {
            this.addLabel(this, "Votre adh\u00e9sion \u00e0 l'AMAP", LABEL_RUBRIQUE);
            for (AdhesionDTO adhesionDTO : mesAdhesionsDTO.enCours) {
                this.displayAdhesion(adhesionDTO, false);
            }
        }
        if (mesAdhesionsDTO.archives.size() > 0) {
            this.addLabel(this, "Vos adh\u00e9sions pass\u00e9es", LABEL_RUBRIQUE);
            for (AdhesionDTO adhesionDTO : mesAdhesionsDTO.archives) {
                this.displayAdhesionArchive(adhesionDTO);
            }
        }
        this.endOfRefresh();
    }

    private void displayAdhesion(AdhesionDTO adhesionDTO, boolean isInscription) {
        Panel p = new Panel();
        p.addStyleName(PANEL_UNCONTRAT);
        HorizontalLayout hl = new HorizontalLayout();
        hl.setMargin(true);
        hl.setSpacing(true);
        hl.setWidth("100%");
        VerticalLayout vl = new VerticalLayout();
        this.addLabel(vl, "Adh\u00e9sion pour " + adhesionDTO.nomPeriode, LABEL_TITRECONTRAT);
        String str = this.formatLibelleAdhesion(adhesionDTO, isInscription);
        BaseUiTools.addHtmlLabel((Layout)vl, str, "libelle-contrat");
        if (!isInscription) {
            this.addLinkImpressionBulletin(adhesionDTO, vl);
        }
        hl.addComponent((Component)vl);
        hl.setExpandRatio((Component)vl, 1.0f);
        VerticalLayout vl2 = new VerticalLayout();
        vl2.setWidth("115px");
        vl2.setSpacing(true);
        hl.addComponent((Component)vl2);
        hl.setComponentAlignment((Component)vl2, Alignment.MIDDLE_CENTER);
        if (isInscription) {
            Button b = this.addButtonAdhesionAdherer("Adh\u00e9rer", adhesionDTO);
            b.addStyleName(BUTTON_PRINCIPAL);
            vl2.addComponent((Component)b);
        } else {
            Button b;
            if (adhesionDTO.isModifiable) {
                b = this.addButtonAdhesionAdherer("Modifier", adhesionDTO);
                vl2.addComponent((Component)b);
            }
            if (adhesionDTO.isSupprimable) {
                b = this.addButtonAdhesionSupprimer("Supprimer", adhesionDTO);
                vl2.addComponent((Component)b);
            }
            Button v = this.addButtonAdhesionVoir("Voir", adhesionDTO);
            v.addStyleName(BUTTON_PRINCIPAL);
            vl2.addComponent((Component)v);
        }
        p.setContent((Component)hl);
        this.addComponent((Component)p);
    }

    private void displayAdhesionArchive(AdhesionDTO adhesionDTO) {
        SimpleDateFormat df2 = new SimpleDateFormat("dd/MM/yyyy");
        Panel p = new Panel();
        p.addStyleName(PANEL_UNCONTRAT);
        HorizontalLayout hl = new HorizontalLayout();
        hl.setMargin(true);
        hl.setSpacing(true);
        hl.setWidth("100%");
        VerticalLayout vl = new VerticalLayout();
        this.addLabel(vl, "Vous \u00e9tiez adh\u00e9rent pour " + adhesionDTO.nomPeriode, LABEL_TITRECONTRAT);
        String str = "Montant de l'adh\u00e9sion : " + new CurrencyTextFieldConverter().convertToString(adhesionDTO.montantAdhesion) + " \u20ac<br/>" + "Cette adh\u00e9sion correspond \u00e0 la p\u00e9riode du " + df2.format(adhesionDTO.dateDebut) + " au " + df2.format(adhesionDTO.dateFin);
        BaseUiTools.addHtmlLabel((Layout)vl, str, "libelle-contrat");
        hl.addComponent((Component)vl);
        p.setContent((Component)hl);
        this.addComponent((Component)p);
    }

    @Override
    public void onPopupClose() {
        this.enter();
    }

    private Button addButtonAdhesionAdherer(String str, AdhesionDTO adhesionDTO) {
        Button b = new Button(str);
        b.setWidth("100%");
        b.addClickListener((Button.ClickListener & Serializable)e -> new PopupAdhesion(adhesionDTO).open(this));
        return b;
    }

    private Button addButtonAdhesionVoir(String str, AdhesionDTO adhesionDTO) {
        Button b = new Button(str);
        b.setWidth("100%");
        b.addClickListener((Button.ClickListener & Serializable)e -> new PopupAdhesionVoir(adhesionDTO).open(this));
        return b;
    }

    private Button addButtonAdhesionSupprimer(String str, AdhesionDTO adhesionDTO) {
        Button b = new Button(str);
        b.setWidth("100%");
        b.addClickListener((Button.ClickListener & Serializable)e -> this.handleAdhesionSupprimer(adhesionDTO));
        return b;
    }

    private void handleAdhesionSupprimer(AdhesionDTO adhesionDTO) {
        String text = "Etes vous s\u00fbr de vouloir supprimer votre adh\u00e9sion ?";
        SuppressionPopup confirmPopup = new SuppressionPopup(text, adhesionDTO.idPeriodeUtilisateur, e -> new MesAdhesionsService().deleteAdhesion((Long)e, false));
        confirmPopup.open(this);
    }

    private void addLinkImpressionBulletin(AdhesionDTO adhesionDTO, VerticalLayout vl) {
        if (adhesionDTO.idBulletin == null) {
            return;
        }
        PEMesAdhesions peMesAdhesions = (PEMesAdhesions)new ParametresService().loadParamEcran(MenuList.MES_ADHESIONS);
        if (peMesAdhesions.impressionBulletinMode == PEMesAdhesions.ImpressionBulletin.FROM_POPUP) {
            return;
        }
        Link l = LinkCreator.createLink(PGBulletinAdhesion.oneBulletinCreated(adhesionDTO.idPeriode, adhesionDTO.idPeriodeUtilisateur));
        l.setCaption("Imprimer mon bulletin d'adh\u00e9sion");
        l.setStyleName("adhesion");
        vl.addComponent((Component)l);
    }

    private String formatLibelleAdhesion(AdhesionDTO adhesionDTO, boolean isInscription) {
        String str;
        SimpleDateFormat df2 = new SimpleDateFormat("dd/MM/yyyy");
        if (isInscription) {
            str = "Il est temps d'adh\u00e9rer pour la nouvelle saison !<br/>";
        } else {
            str = "Vous avez renouvel\u00e9 votre adh\u00e9sion \u00e0 l'AMAP. Montant : " + new CurrencyTextFieldConverter().convertToString(adhesionDTO.montantAdhesion) + " \u20ac<br/>";
            str = adhesionDTO.etatPaiementAdhesion == EtatPaiementAdhesion.A_FOURNIR ? String.valueOf(str) + "Sauf si cela est d\u00e9j\u00e0 fait, le paiement est \u00e0 fournir au tr\u00e9sorier.<br/><br/>" : String.valueOf(str) + "Votre paiement par " + (Object)((Object)adhesionDTO.typePaiementAdhesion) + " a bien \u00e9t\u00e9 r\u00e9ceptionn\u00e9 par le tr\u00e9sorier.<br/><br/>";
        }
        str = String.valueOf(str) + "<b>Cette adh\u00e9sion couvre la p\u00e9riode du " + df2.format(adhesionDTO.dateDebut) + " au " + df2.format(adhesionDTO.dateFin) + "</b><br/>";
        return str;
    }

    private Label addLabel(VerticalLayout layout, String str, String style) {
        Label tf = new Label(str);
        tf.addStyleName(style);
        layout.addComponent((Component)tf);
        return tf;
    }
}

