/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.mesadhesions;

import com.vaadin.data.util.converter.Converter;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.GenericUtils;
import fr.amapj.model.models.param.paramecran.PEMesAdhesions;
import fr.amapj.service.services.edgenerator.pdf.PGBulletinAdhesion;
import fr.amapj.service.services.mesadhesions.AdhesionDTO;
import fr.amapj.service.services.mesadhesions.MesAdhesionsService;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.okcancelpopup.OKCancelPopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;

public class PopupAdhesion
extends OKCancelPopup {
    private AdhesionDTO dto;
    private State state;
    private TextField textField;

    public PopupAdhesion(AdhesionDTO adhesionDTO) {
        this.popupTitle = "Adh\u00e9sion \u00e0 l'AMAP";
        this.dto = adhesionDTO;
        this.state = this.computeState();
        if (this.state == State.SAISIE) {
            this.saveButtonTitle = "J'adh\u00e8re";
        } else {
            this.saveButtonTitle = "OK";
            this.hasCancelButton = false;
        }
        this.setWidth(40, 450);
    }

    private State computeState() {
        PEMesAdhesions peMesAdhesions = (PEMesAdhesions)new ParametresService().loadParamEcran(MenuList.MES_ADHESIONS);
        if (peMesAdhesions.gestionAdhesion == PEMesAdhesions.GestionAdhesion.INSCRIPTION_ADHERENTS) {
            return State.SAISIE;
        }
        return State.TRESORIER;
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        String entete = this.getEntete();
        Label l = new Label(entete, ContentMode.HTML);
        l.addStyleName("big");
        contentLayout.addComponent((Component)l);
        if (this.state == State.SAISIE) {
            FormLayout f = new FormLayout();
            this.textField = BaseUiTools.createCurrencyField("Montant de votre adh\u00e9sion", false);
            this.textField.setConvertedValue((Object)new Integer(this.getPropositionMontant()));
            this.textField.addStyleName("cell-saisie");
            f.addComponent((Component)this.textField);
            contentLayout.addComponent((Component)f);
        }
        String bas = this.getBasPage();
        l = new Label(bas, ContentMode.HTML);
        l.addStyleName("big");
        contentLayout.addComponent((Component)l);
        this.addLinkImpressionBulletin(contentLayout);
    }

    private int getPropositionMontant() {
        if (this.dto.idPeriodeUtilisateur != null) {
            return this.dto.montantAdhesion;
        }
        return this.dto.montantConseille;
    }

    @Override
    protected boolean performSauvegarder() {
        if (this.state == State.TRESORIER) {
            return true;
        }
        GenericUtils.Ret<Integer> qte = this.readMontant();
        if (!qte.isOK()) {
            Notification.show((String)qte.msg());
            return false;
        }
        new MesAdhesionsService().createOrUpdateAdhesion(this.dto, qte.get());
        return true;
    }

    private GenericUtils.Ret<Integer> readMontant() {
        int qte = 0;
        try {
            Integer val = (Integer)this.textField.getConvertedValue();
            if (val != null) {
                qte = val;
            }
        }
        catch (Converter.ConversionException conversionException) {
            return GenericUtils.Ret.error("Erreur de saisie");
        }
        if (qte < this.dto.montantMini) {
            return GenericUtils.Ret.error("Le montant est insuffisant. Le montant minimum est " + new CurrencyTextFieldConverter().convertToString(this.dto.montantMini) + " \u20ac");
        }
        return GenericUtils.Ret.ok(qte);
    }

    private String getEntete() {
        String str = "";
        str = this.state == State.SAISIE ? "<b>Veuillez saisir ci dessous le montant de votre adhesion</b><br/>" : "<b>L'adh\u00e9sion est \u00e0 remettre \u00e0 votre tr\u00e9sorier.</b><br/>";
        str = String.valueOf(str) + "Le montant conseill\u00e9 est de " + new CurrencyTextFieldConverter().convertToString(this.dto.montantConseille) + " \u20ac<br/>";
        if (this.dto.montantConseille != this.dto.montantMini) {
            str = String.valueOf(str) + "Le montant minimum est de " + new CurrencyTextFieldConverter().convertToString(this.dto.montantMini) + " \u20ac<br/><br/>";
        }
        return str;
    }

    private String getBasPage() {
        String str = "";
        if (this.dto.libCheque != null) {
            str = String.valueOf(str) + "Ordre du ch\u00e8que : " + PopupAdhesion.s(this.dto.libCheque) + "<br/><br/>";
        }
        if (this.dto.textPaiement != null) {
            str = String.valueOf(str) + PopupAdhesion.s(this.dto.textPaiement) + "<br/>";
        }
        return str;
    }

    private void addLinkImpressionBulletin(VerticalLayout vl) {
        if (this.dto.idBulletin == null) {
            return;
        }
        vl.addComponent((Component)new Label("<br/>", ContentMode.HTML));
        Link l = LinkCreator.createLink(PGBulletinAdhesion.oneBulletinNotCreated(this.dto.idPeriode, this.dto.idUtilisateur, () -> this.montantImpression()));
        l.setCaption("Imprimer mon bulletin d'adh\u00e9sion");
        vl.addComponent((Component)l);
    }

    private GenericUtils.Ret<Integer> montantImpression() {
        if (this.state == State.SAISIE) {
            return this.readMontant();
        }
        return GenericUtils.Ret.ok(this.dto.montantConseille);
    }

    public static enum State {
        SAISIE,
        TRESORIER;

    }
}

