/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.mescontrats;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.param.paramecran.PEMesContrats;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineDTO;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineService;
import fr.amapj.service.services.mescontrats.small.SmallContratDTO;
import fr.amapj.service.services.mescontrats.small.SmallContratsService;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.template.FrontOfficeView;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.mescontrats.InscriptionButtonModule;
import fr.amapj.view.views.mescontrats.PopupSignatureAmapienOneByOne;
import fr.amapj.view.views.mescontrats.TelechargerMesContrat;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class MesContratsView
extends FrontOfficeView
implements PopupListener {
    public static String LABEL_RUBRIQUE = "rubrique";
    public static String LABEL_TITRECONTRAT = "titrecontrat";
    public static String PANEL_UNCONTRAT = "uncontrat";
    public static String BUTTON_PRINCIPAL = "principal";
    private PEMesContrats peMesContrats;

    @Override
    public String getMainStyleName() {
        return "contrat";
    }

    @Override
    public void enter() {
        this.peMesContrats = (PEMesContrats)new ParametresService().loadParamEcran(MenuList.MES_CONTRATS);
        this.refresh();
    }

    private Label addLabel(VerticalLayout layout, String str) {
        Label tf = new Label(str);
        tf.addStyleName(LABEL_RUBRIQUE);
        layout.addComponent((Component)tf);
        return tf;
    }

    public void refresh() {
        List<SmallContratDTO> contratRetardataires;
        this.removeAllComponents();
        InscriptionButtonModule inscriptionButtonModule = new InscriptionButtonModule(this);
        Long userId = SessionManager.getUserId();
        List<SmallContratDTO> mesContratsDTO = new SmallContratsService().getMesContrats(userId);
        List<DocEngagementSignOnLineDTO> docEngagements = new DocEngagementSignOnLineService().getAllContratASignerByAmapien(userId);
        if (docEngagements.size() > 0) {
            this.addBlocDocEngagement(docEngagements, userId);
        }
        Comparator<SmallContratDTO> cmp = Comparator.comparing(e -> e.dateFinInscription, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(e -> e.nom);
        List<SmallContratDTO> newContrats = mesContratsDTO.stream().filter(e -> e.contratId == null && !e.inscriptionDTO.isRetardataire).sorted(cmp).collect(Collectors.toList());
        this.addOneBloc("Les nouveaux contrats disponibles", newContrats, inscriptionButtonModule);
        if (this.peMesContrats.affichageContratRetardataire == ChoixOuiNon.OUI && (contratRetardataires = mesContratsDTO.stream().filter(e -> e.contratId == null && e.inscriptionDTO.isRetardataire).sorted(cmp).collect(Collectors.toList())).size() > 0) {
            this.addOneBloc("Contrats en cours, encore disponibles", contratRetardataires, inscriptionButtonModule);
        }
        List<SmallContratDTO> existingContrats = mesContratsDTO.stream().filter(e -> e.contratId != null).sorted(Comparator.comparing(e -> e.dateFin)).collect(Collectors.toList());
        this.addOneBloc("Mes contrats existants", existingContrats, inscriptionButtonModule);
        if (existingContrats.size() > 0) {
            Button telechargerButton = new Button("T\u00e9l\u00e9charger les documents relatifs \u00e0 mes contrats ...");
            telechargerButton.setIcon((Resource)FontAwesome.PRINT);
            telechargerButton.addStyleName("borderless");
            telechargerButton.addStyleName("large");
            telechargerButton.addClickListener((Button.ClickListener & Serializable)e -> this.handleTelecharger(existingContrats));
            this.addComponent((Component)telechargerButton);
            this.setComponentAlignment((Component)telechargerButton, Alignment.MIDDLE_LEFT);
        }
        this.endOfRefresh();
    }

    private void addBlocDocEngagement(List<DocEngagementSignOnLineDTO> docEngagements, Long userId) {
        this.addLabel(this, "\ud83d\udd14 Les documents d'engagement \u00e0 signer");
        Panel p = new Panel();
        p.addStyleName(PANEL_UNCONTRAT);
        HorizontalLayout hl = new HorizontalLayout();
        hl.setMargin(true);
        hl.setSpacing(true);
        hl.setWidth("100%");
        VerticalLayout vl = new VerticalLayout();
        BaseUiTools.addHtmlLabel((Layout)vl, this.getLibelleEngagement(docEngagements), "libelle-contrat");
        hl.addComponent((Component)vl);
        hl.setExpandRatio((Component)vl, 1.0f);
        VerticalLayout vl2 = new VerticalLayout();
        vl2.setWidth("115px");
        vl2.setSpacing(true);
        Button b = new Button("Signer");
        b.setWidth("100%");
        b.addStyleName("signature");
        b.setIcon((Resource)FontAwesome.PENCIL);
        b.addClickListener((Button.ClickListener & Serializable)e -> this.handleSignature(userId));
        vl2.addComponent((Component)b);
        hl.addComponent((Component)vl2);
        hl.setComponentAlignment((Component)vl2, Alignment.MIDDLE_CENTER);
        p.setContent((Component)hl);
        this.addComponent((Component)p);
    }

    private void handleSignature(Long userId) {
        new PopupSignatureAmapienOneByOne(userId).open(() -> this.refresh());
    }

    private String getLibelleEngagement(List<DocEngagementSignOnLineDTO> docEngagements) {
        String str = "Vous avez " + docEngagements.size() + " documents d'engagement \u00e0 signer en ligne pour les contrats suivants : ";
        if (docEngagements.size() == 1) {
            str = "Vous avez un document d'engagement \u00e0 signer en ligne pour le contrat suivant : ";
        }
        str = String.valueOf(str) + "<ul>";
        for (DocEngagementSignOnLineDTO eng : docEngagements) {
            str = String.valueOf(str) + "<li>" + MesContratsView.s(eng.nomModeleContrat) + "</li>";
        }
        str = String.valueOf(str) + "</ul>";
        return str;
    }

    private void addOneBloc(String lib, List<SmallContratDTO> contrats, InscriptionButtonModule inscriptionButtonModule) {
        this.addLabel(this, lib);
        for (SmallContratDTO c : contrats) {
            Panel p = new Panel();
            p.addStyleName(PANEL_UNCONTRAT);
            HorizontalLayout hl = new HorizontalLayout();
            hl.setMargin(true);
            hl.setSpacing(true);
            hl.setWidth("100%");
            VerticalLayout vl = new VerticalLayout();
            Label lab = new Label(c.nom);
            lab.addStyleName(LABEL_TITRECONTRAT);
            vl.addComponent((Component)lab);
            BaseUiTools.addHtmlLabel((Layout)vl, c.inscriptionDTO.libContrat, "libelle-contrat");
            hl.addComponent((Component)vl);
            hl.setExpandRatio((Component)vl, 1.0f);
            inscriptionButtonModule.buildBloc(hl, c);
            p.setContent((Component)hl);
            this.addComponent((Component)p);
        }
    }

    private void handleTelecharger(List<SmallContratDTO> existingContrats) {
        new TelechargerMesContrat().displayPopupTelechargerMesContrat(this.peMesContrats, existingContrats, this);
    }

    @Override
    public void onPopupClose() {
        this.refresh();
    }
}

