/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.detailperiode;

import fr.amapj.service.services.permanence.detailperiode.calculauto.CalculAutoPeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;

public class PopupCalculAutoPermanence
extends WizardFormPopup {
    private Long idPeriodePermanence;

    public PopupCalculAutoPermanence(Long idPeriodePermanence) {
        this.setWidth(80);
        this.popupTitle = "Calcul automatique des inscriptions aux permanences";
        this.idPeriodePermanence = idPeriodePermanence;
    }

    @Override
    protected void configure() {
        this.add(() -> this.addAide());
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addResultatAffectation());
    }

    private void addAide() {
        this.setStepTitle("explication sur le fonctionnement de cet outil");
        String str = "Cet outil va vous permettre de calculer automatique les inscripptions aux permanences sur une p\u00e9riode compl\u00e8te.</br><br/>Cet outil positionne lui m\u00eame les amapiens sur les dates de permanence, de fa\u00e7on al\u00e9atoire<br/>Par contre, cet outil essaye autant que possible de mettre les amapiens \u00e0 des permanences o\u00f9 ils ont un panier \u00e0 venir chercher<br/><br/><br/>Cet outil prend bien s\u00fbr en compte le nombre de participations affect\u00e9es \u00e0 chaque personne.<br/><br/>Il est possible d'utiliser cet outil m\u00eame si des personnes sont d\u00e9j\u00e0 inscrites.";
        this.addHtml(str);
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("informations g\u00e9n\u00e9rales sur cette p\u00e9riode");
        PeriodePermanenceDTO dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(this.idPeriodePermanence);
        String bilan = new PeriodePermanenceService().computeBilan(dto);
        this.addHtml(bilan);
        this.addHtml("Cliquer maintenant sur Sauvegarder pour lancer le calcul automatique des inscriptions, ou Annuler pour ne rien faire");
    }

    private void addResultatAffectation() {
        this.setAllButtonsAsOK();
        String bilan = new CalculAutoPeriodePermanenceService().performPlanification(this.idPeriodePermanence);
        this.setStepTitle("r\u00e9sultat du calcul");
        if (bilan.length() == 0) {
            this.addHtml("L'affectation a \u00e9t\u00e9 r\u00e9alis\u00e9e normalement");
        } else {
            this.addHtml("L'affectation a \u00e9t\u00e9 r\u00e9alis\u00e9 avec les remarques suivantes :");
            this.addHtml(bilan);
        }
    }

    @Override
    protected void performSauvegarder() {
    }
}

