/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.detailperiode;

import com.vaadin.ui.ComboBox;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.permanence.detailperiode.DetailPeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PermanenceCellDTO;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import fr.amapj.view.views.searcher.SDUtilisateurPermanence;
import java.util.List;

public class PopupModifPermanence
extends WizardFormPopup {
    private ComplexTableBuilder<PermanenceCellDTO> builder;
    PeriodePermanenceDateDTO dto;

    public PopupModifPermanence(Long idPeriodePermanenceDate) {
        this.setWidth(80);
        this.popupTitle = "Modification d'une permanence";
        this.dto = new PeriodePermanenceService().loadOneDatePermanence(idPeriodePermanenceDate);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldUtilisateurs(), () -> this.checkFieldUtilisateur());
    }

    private void addFieldUtilisateurs() {
        this.setStepTitle("les personnes de permanence");
        List<Utilisateur> allowed = new DetailPeriodePermanenceService().computeAllowedUser(this.dto.idPeriodePermanenceDate);
        SDUtilisateurPermanence searcher = new SDUtilisateurPermanence(allowed);
        this.builder = new ComplexTableBuilder<PermanenceCellDTO>(this.dto.permanenceCellDTOs);
        this.builder.setPageLength(8);
        this.builder.addString("Role", false, 300, e -> e.nomRole);
        this.builder.addSearcher("Adh\u00e9rent", "cb", true, 300, (T e) -> e.idUtilisateur, searcher);
        this.addComplexTable(this.builder);
    }

    private String checkFieldUtilisateur() {
        int i = 0;
        while (i < this.dto.permanenceCellDTOs.size()) {
            PermanenceCellDTO lig = this.dto.permanenceCellDTOs.get(i);
            ComboBox cb = (ComboBox)this.builder.getComponent(i, "cb");
            lig.idUtilisateur = (Long)cb.getConvertedValue();
            ++i;
        }
        return this.dto.checkRegleInscription();
    }

    @Override
    protected void performSauvegarder() {
        new DetailPeriodePermanenceService().updateDetailPeriodePermanence(this.dto);
    }
}

