/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.mespermanences;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.service.services.permanence.mespermanences.UnePeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import java.util.Date;

public class MesPermanencesUtils {
    public static String getLibCompteur(UnePeriodePermanenceDTO periodePermanenceDTO) {
        if (periodePermanenceDTO.nbSouhaite == 0) {
            String msg = "Vous \u00eates inscrit sur " + periodePermanenceDTO.nbInscription + " positions, vous pouvez vous inscrire le nombre de fois que vous voulez.";
            return msg;
        }
        String msg = "Vous \u00eates inscrit sur " + periodePermanenceDTO.nbInscription + " positions, vous devez vous inscrire pour " + periodePermanenceDTO.nbSouhaite + " positions.";
        int delta = periodePermanenceDTO.nbSouhaite - periodePermanenceDTO.nbInscription;
        msg = delta <= 0 ? String.valueOf(msg) + " C'est OK!" : String.valueOf(msg) + " Encore " + delta + "!";
        return msg;
    }

    public static boolean couldSubcribeMore(UnePeriodePermanenceDTO periodePermanenceDTO) {
        if (periodePermanenceDTO.depassementAutorise == ChoixOuiNon.OUI) {
            return true;
        }
        int delta = periodePermanenceDTO.nbSouhaite - periodePermanenceDTO.nbInscription;
        return delta > 0;
    }

    public static boolean isDateModifiable(UnePeriodePermanenceDTO periodePermanenceDTO, PeriodePermanenceDateDTO detail) {
        Date nowNoTime = DateUtils.getDateWithNoTime();
        switch (periodePermanenceDTO.nature) {
            case INSCRIPTION_NON_LIBRE: {
                return false;
            }
            case INSCRIPTION_LIBRE_AVEC_DATE_LIMITE: {
                if (nowNoTime.after(periodePermanenceDTO.dateFinInscription)) {
                    return false;
                }
                return !nowNoTime.after(detail.datePerm);
            }
            case INSCRIPTION_LIBRE_FLOTTANT: {
                return !detail.datePerm.before(periodePermanenceDTO.firstDateModifiable);
            }
        }
        throw new AmapjRuntimeException();
    }
}

