/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.mespermanences;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.service.services.edgenerator.excel.permanence.EGPlanningPermanence;
import fr.amapj.service.services.permanence.mespermanences.MesPermanenceDTO;
import fr.amapj.service.services.permanence.mespermanences.MesPermanencesService;
import fr.amapj.service.services.permanence.mespermanences.UnePeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.SmallPeriodePermanenceDTO;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.excelgenerator.TelechargerPopup;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.swicthpopup.SwitchPopup;
import fr.amapj.view.engine.template.FrontOfficeView;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.permanence.mespermanences.grille.GrilleInscriptionPermanence;
import fr.amapj.view.views.permanence.periode.grille.VisualiserPeriodePermanenceGrillePart;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;

public class MesPermanencesView
extends FrontOfficeView
implements PopupListener {
    private SimpleDateFormat df1 = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
    public static String LABEL_RUBRIQUE = "rubrique";
    public static String LABEL_TITRECONTRAT = "titrecontrat";
    public static String PANEL_UNCONTRAT = "uncontrat";
    public static String BUTTON_PRINCIPAL = "principal";
    SimpleDateFormat df = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
    VerticalLayout layout = null;
    public MesPermanenceDTO mesContratsDTO;

    @Override
    public String getMainStyleName() {
        return "mespermanences";
    }

    @Override
    public void enter() {
        this.refresh();
    }

    private Label addLabel(VerticalLayout layout, String str) {
        Label tf = new Label(str);
        tf.addStyleName(LABEL_RUBRIQUE);
        layout.addComponent((Component)tf);
        return tf;
    }

    private Button addButtonInscription(String str, UnePeriodePermanenceDTO c) {
        Button b = new Button(str);
        b.addClickListener((Button.ClickListener & Serializable)e -> this.handleInscription(c));
        return b;
    }

    protected void handleInscription(UnePeriodePermanenceDTO c) {
        GrilleInscriptionPermanence.open(new GrilleInscriptionPermanence(c.idPeriodePermanence, SessionManager.getUserId()), this);
    }

    public void refresh() {
        long idUser = SessionManager.getUserId();
        this.mesContratsDTO = new MesPermanencesService().getMesPermanenceDTO(idUser);
        this.layout = this;
        this.layout.removeAllComponents();
        if (this.mesContratsDTO.mesPeriodesPermanences.size() > 0) {
            this.addLabel(this.layout, "S'inscrire aux permanences");
            for (UnePeriodePermanenceDTO c : this.mesContratsDTO.mesPeriodesPermanences) {
                Panel p = new Panel();
                p.addStyleName(PANEL_UNCONTRAT);
                HorizontalLayout hl = new HorizontalLayout();
                hl.setMargin(true);
                hl.setSpacing(true);
                hl.setWidth("100%");
                VerticalLayout vl = new VerticalLayout();
                Label lab = new Label(c.nom);
                lab.addStyleName(LABEL_TITRECONTRAT);
                vl.addComponent((Component)lab);
                String str = this.formatLibelleContrat(c, true);
                BaseUiTools.addHtmlLabel((Layout)vl, str, "libelle-contrat");
                hl.addComponent((Component)vl);
                hl.setExpandRatio((Component)vl, 1.0f);
                VerticalLayout vl2 = new VerticalLayout();
                vl2.setWidth("115px");
                vl2.setSpacing(true);
                String libButton = this.getLibButton(c);
                Button b = this.addButtonInscription(libButton, c);
                b.setWidth("100%");
                b.addStyleName(BUTTON_PRINCIPAL);
                vl2.addComponent((Component)b);
                hl.addComponent((Component)vl2);
                hl.setComponentAlignment((Component)vl2, Alignment.MIDDLE_CENTER);
                p.setContent((Component)hl);
                this.layout.addComponent((Component)p);
            }
        }
        this.addLabel(this.layout, "Les dates de mes permanences");
        VerticalLayout vl1 = BaseUiTools.addPanel((Layout)this, "mes-permanences");
        String mesPermanences = this.getLibMesPermanences(idUser);
        BaseUiTools.addHtmlLabel((Layout)vl1, mesPermanences, "ligne");
        this.addLabel(this.layout, "Consulter les plannings de permanence");
        VerticalLayout vl2 = BaseUiTools.addPanel((Layout)this, "mes-permanences");
        Button onLineButton = new Button("Visualiser les plannings de permanence ...");
        onLineButton.setIcon((Resource)FontAwesome.EYE);
        onLineButton.addStyleName("borderless");
        onLineButton.addStyleName("large");
        onLineButton.addClickListener((Button.ClickListener & Serializable)e -> this.handleVisualiser());
        vl2.addComponent((Component)onLineButton);
        vl2.setComponentAlignment((Component)onLineButton, Alignment.MIDDLE_LEFT);
        Button telechargerButton = new Button("T\u00e9l\u00e9charger les plannings de permanence au format tableur ...");
        telechargerButton.setIcon((Resource)FontAwesome.PRINT);
        telechargerButton.addStyleName("borderless");
        telechargerButton.addStyleName("large");
        telechargerButton.addClickListener((Button.ClickListener & Serializable)e -> this.handleTelecharger());
        vl2.addComponent((Component)telechargerButton);
        vl2.setComponentAlignment((Component)telechargerButton, Alignment.MIDDLE_LEFT);
        this.endOfRefresh();
    }

    private void handleVisualiser() {
        List<SmallPeriodePermanenceDTO> dtos = new MesPermanencesService().getAllPeriodeInFuture();
        SwitchPopup popup = new SwitchPopup("Choix de la p\u00e9riode de permanence \u00e0 visualiser", 50);
        popup.setLine1("Veuillez indiquer la p\u00e9riode de permanence que vous souhaitez visualiser :");
        for (SmallPeriodePermanenceDTO dto : dtos) {
            popup.addLine("Planning permanence " + dto.nom, () -> new VisualiserPeriodePermanenceGrillePart(smallPeriodePermanenceDTO.id, SessionManager.getUserId()));
        }
        popup.open(this);
    }

    private void handleTelecharger() {
        TelechargerPopup popup = new TelechargerPopup("T\u00e9l\u00e9chargement des plannings de permanence", 80);
        List<SmallPeriodePermanenceDTO> dtos = new MesPermanencesService().getAllPeriodeInFuture();
        for (SmallPeriodePermanenceDTO dto : dtos) {
            popup.addGenerator(new EGPlanningPermanence(dto.id, null));
        }
        CorePopup.open(popup, this);
    }

    private String getLibMesPermanences(Long idUser) {
        StringBuffer buf = new StringBuffer();
        buf.append("Vous \u00eates inscrit pour faire les permanences suivantes :<ul>");
        for (PeriodePermanenceDateDTO permanence : this.mesContratsDTO.mesPermanencesFutures) {
            buf.append("<li>" + this.df1.format(permanence.datePerm) + " - " + MesPermanencesView.s(permanence.nomPeriode) + " - R\u00f4le : " + MesPermanencesView.s(permanence.getRolesAsString(idUser)) + "</li>");
        }
        buf.append("</ul>");
        return buf.toString();
    }

    private String getLibButton(UnePeriodePermanenceDTO c) {
        if (c.nbInscription >= c.nbSouhaite) {
            return "Modifier";
        }
        return "S'inscrire";
    }

    private String formatLibelleContrat(UnePeriodePermanenceDTO c, boolean isInscription) {
        switch (c.nature) {
            case INSCRIPTION_LIBRE_AVEC_DATE_LIMITE: {
                if (c.nbSouhaite == 0) {
                    return this.formatLibelleAvecDateLimiteSansObligation(c);
                }
                return this.formatLibelleAvecDateLimiteAvecObligation(c);
            }
            case INSCRIPTION_LIBRE_FLOTTANT: {
                if (c.nbSouhaite == 0) {
                    return this.formatLibelleSansDateLimiteSansObligation(c);
                }
                return this.formatLibelleSansDateLimiteAvecObligation(c);
            }
        }
        throw new AmapjRuntimeException("" + (Object)((Object)c.nature));
    }

    private String formatLibelleAvecDateLimiteSansObligation(UnePeriodePermanenceDTO c) {
        String str = MesPermanencesView.s(c.description);
        str = String.valueOf(str) + "<br/>";
        str = String.valueOf(str) + "<b>Vous avez la possibilit\u00e9 de vous inscrire le nombre de fois que vous voulez entre <br/>le " + this.df.format(c.dateDebut) + " et le " + this.df.format(c.dateFin) + " (\u00e0 choisir parmi " + c.nbDatePermanence + " dates).</b>";
        str = String.valueOf(str) + "<br/>";
        str = c.nbInscription > 0 ? String.valueOf(str) + "Vous \u00eates inscrit sur " + c.nbInscription + " dates." : String.valueOf(str) + "Vous n'\u00eates pas inscrit.";
        str = String.valueOf(str) + "<br/>";
        str = String.valueOf(str) + "Vous pouvez modifier vos choix jusqu'au " + this.df.format(c.dateFinInscription) + " minuit.";
        str = String.valueOf(str) + "<br/>";
        return str;
    }

    private String formatLibelleAvecDateLimiteAvecObligation(UnePeriodePermanenceDTO c) {
        String str = MesPermanencesView.s(c.description);
        str = String.valueOf(str) + "<br/>";
        str = String.valueOf(str) + "<b>Il est demand\u00e9 de r\u00e9aliser " + c.nbSouhaite + " permanences entre le " + this.df.format(c.dateDebut) + " et le " + this.df.format(c.dateFin) + "<br/>(\u00e0 choisir parmi " + c.nbDatePermanence + " dates).</b>";
        str = String.valueOf(str) + "<br/>";
        if (c.nbInscription >= c.nbSouhaite) {
            str = String.valueOf(str) + "Vous \u00eates bien inscrit sur " + c.nbInscription + " dates.";
            str = String.valueOf(str) + "<br/>";
            str = String.valueOf(str) + "Vous pouvez modifier vos choix jusqu'au " + this.df.format(c.dateFinInscription) + " minuit.";
        } else if (c.nbInscription == 0) {
            str = String.valueOf(str) + "Vous n'\u00eates pas inscrit, merci de vous inscrire.";
            str = String.valueOf(str) + "<br/>";
            str = String.valueOf(str) + "Vous devez vous inscrire avant le " + this.df.format(c.dateFinInscription) + " minuit.";
        } else if (c.nbInscription < c.nbSouhaite) {
            str = String.valueOf(str) + "Vous \u00eates inscrit sur " + c.nbInscription + " permanences, merci de vous inscrire encore sur " + (c.nbSouhaite - c.nbInscription) + " dates";
            str = String.valueOf(str) + "<br/>";
            str = String.valueOf(str) + "Vous devez finaliser vos inscriptions avant le " + this.df.format(c.dateFinInscription) + " minuit.";
        }
        str = String.valueOf(str) + "<br/>";
        return str;
    }

    private String formatLibelleSansDateLimiteSansObligation(UnePeriodePermanenceDTO c) {
        String str = MesPermanencesView.s(c.description);
        str = String.valueOf(str) + "<br/>";
        str = String.valueOf(str) + "<b>Vous avez la possibilit\u00e9 de vous inscrire le nombre de fois que vous voulez entre <br/>le " + this.df.format(c.dateDebut) + " et le " + this.df.format(c.dateFin) + " (\u00e0 choisir parmi " + c.nbDatePermanence + " dates).</b>";
        str = String.valueOf(str) + "<br/>";
        if (c.nbInscription > 0) {
            str = String.valueOf(str) + "Vous \u00eates inscrit sur " + c.nbInscription + " dates.";
            str = String.valueOf(str) + "<br/>";
            str = String.valueOf(str) + "Vous pouvez modifier vos choix pour les permanences plac\u00e9es apr\u00e8s le " + this.df.format(c.firstDateModifiable);
            str = String.valueOf(str) + "<br/>";
        } else {
            str = String.valueOf(str) + "Vous n'\u00eates pas inscrit.";
            str = String.valueOf(str) + "<br/>";
            str = String.valueOf(str) + "Vous pouvez vous inscrire pour les permanences plac\u00e9es apr\u00e8s le " + this.df.format(c.firstDateModifiable);
            str = String.valueOf(str) + "<br/>";
        }
        return str;
    }

    private String formatLibelleSansDateLimiteAvecObligation(UnePeriodePermanenceDTO c) {
        String str = MesPermanencesView.s(c.description);
        str = String.valueOf(str) + "<br/>";
        str = String.valueOf(str) + "<b>Il est demand\u00e9 de r\u00e9aliser " + c.nbSouhaite + " permanences entre le " + this.df.format(c.dateDebut) + " et le " + this.df.format(c.dateFin) + "<br/>(\u00e0 choisir parmi " + c.nbDatePermanence + " dates).</b>";
        str = String.valueOf(str) + "<br/>";
        if (c.nbInscription >= c.nbSouhaite) {
            str = String.valueOf(str) + "Vous \u00eates bien inscrit sur " + c.nbInscription + " dates.";
            str = String.valueOf(str) + "<br/>";
            str = String.valueOf(str) + "Vous pouvez modifier vos choix pour vos permanences plac\u00e9es apr\u00e8s le " + this.df.format(c.firstDateModifiable);
        } else if (c.nbInscription == 0) {
            str = String.valueOf(str) + "Vous n'\u00eates pas inscrit, merci de vous inscrire.";
            str = String.valueOf(str) + "<br/>";
            str = String.valueOf(str) + "Vous pouvez vous inscrire pour les permanences plac\u00e9es apr\u00e8s le " + this.df.format(c.firstDateModifiable);
        } else if (c.nbInscription < c.nbSouhaite) {
            str = String.valueOf(str) + "Vous \u00eates inscrit sur " + c.nbInscription + " permanences, merci de vous inscrire encore sur " + (c.nbSouhaite - c.nbInscription) + " dates";
            str = String.valueOf(str) + "<br/>";
            str = String.valueOf(str) + "Vous pouvez vous inscrire pour les permanences plac\u00e9es apr\u00e8s le " + this.df.format(c.firstDateModifiable);
        }
        str = String.valueOf(str) + "<br/>";
        return str;
    }

    @Override
    public void onPopupClose() {
        this.refresh();
    }
}

