/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.mespermanences.grille;

import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.models.permanence.periode.RegleInscriptionPeriodePermanence;
import fr.amapj.service.services.permanence.mespermanences.MesPermanencesService;
import fr.amapj.service.services.permanence.mespermanences.UnePeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PermanenceCellDTO;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.popup.okcancelpopup.OKCancelPopup;
import fr.amapj.view.engine.searcher.Searcher;
import fr.amapj.view.views.permanence.mespermanences.MesPermanencesUtils;
import fr.amapj.view.views.searcher.SDRoleAllowed;
import java.util.ArrayList;
import java.util.List;

public class InscriptionPopup
extends OKCancelPopup {
    private PeriodePermanenceDateDTO date;
    private Long userId;
    private Long idPeriodePermanence;
    private Long selectedRole;
    private Searcher box;

    public InscriptionPopup(PeriodePermanenceDateDTO date, Long userId, Long idPeriodePermanence) {
        this.userId = userId;
        this.idPeriodePermanence = idPeriodePermanence;
        this.popupTitle = "S'inscrire";
        this.date = date;
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        UnePeriodePermanenceDTO periodePermanenceDTO = new MesPermanencesService().loadCompteurPeriodePermanence(this.idPeriodePermanence, this.userId);
        if (!MesPermanencesUtils.couldSubcribeMore(periodePermanenceDTO)) {
            Label l = new Label("Il est impossible de vous inscrire car vous \u00eates d\u00e9j\u00e0 inscrit sur suffisamment de dates.");
            contentLayout.addComponent((Component)l);
            this.hasSaveButton = false;
            return;
        }
        List<Long> roleIds = this.findRolesId();
        if (roleIds.size() == 0) {
            Label l = new Label("Impossible de vous inscrire - plus de roles.");
            contentLayout.addComponent((Component)l);
            this.hasSaveButton = false;
            return;
        }
        if (roleIds.size() == 1) {
            Label l = new Label("Etes vous s\u00fbr de vouloir vous inscrire pour la date du " + FormatUtils.getFullDate().format(this.date.datePerm) + " ? ");
            contentLayout.addComponent((Component)l);
            this.selectedRole = roleIds.get(0);
            return;
        }
        Label l = new Label("Veuillez choisir votre r\u00f4le pour vous inscrire \u00e0 la date du " + FormatUtils.getFullDate().format(this.date.datePerm) + " : ");
        contentLayout.addComponent((Component)l);
        FormLayout f = new FormLayout();
        this.box = new Searcher(new SDRoleAllowed(roleIds));
        this.box.setWidth("80%");
        f.addComponent((Component)this.box);
        contentLayout.addComponent((Component)f);
    }

    private List<Long> findRolesId() {
        ArrayList<Long> res = new ArrayList<Long>();
        for (PermanenceCellDTO cell : this.date.permanenceCellDTOs) {
            if (cell.idUtilisateur != null || res.contains(cell.idRole)) continue;
            res.add(cell.idRole);
        }
        return res;
    }

    @Override
    protected boolean performSauvegarder() {
        MesPermanencesService.InscriptionMessage msg;
        if (this.selectedRole == null) {
            this.selectedRole = (Long)this.box.getConvertedValue();
            if (this.selectedRole == null) {
                return false;
            }
        }
        if ((msg = new MesPermanencesService().inscription(this.userId, this.date.idPeriodePermanenceDate, this.selectedRole, RegleInscriptionPeriodePermanence.UNE_INSCRIPTION_PAR_DATE)) != null) {
            String lib = InscriptionPopup.computeLib(msg);
            MessagePopup popup = new MessagePopup("Impossible de s'inscrire", CorePopup.ColorStyle.RED, "Vous ne pouvez pas vous inscrire car " + lib);
            MessagePopup.open(popup);
        }
        return true;
    }

    public static String computeLib(MesPermanencesService.InscriptionMessage msg) {
        switch (msg) {
            case DEJA_INSCRIT_CETTE_DATE: {
                return "vous \u00eates d\u00e9j\u00e0 inscrit \u00e0 cette date.";
            }
            case NOMBRE_SUFFISANT: {
                return "Vous \u00eates inscrit un nombre suffisant de fois sur la p\u00e9riode.";
            }
            case PAS_DE_PLACE_CETTE_DATE: {
                return "il n'y a plus de place disponible \u00e0 cette date.";
            }
            case PLACE_NON_DISPONIBLE: {
                return "cette place n'est plus disponible.";
            }
        }
        return null;
    }
}

