/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.mespermanences.grille;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.CollectionUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.LongUtils;
import fr.amapj.model.models.permanence.periode.RegleInscriptionPeriodePermanence;
import fr.amapj.service.services.permanence.mespermanences.MesPermanencesService;
import fr.amapj.service.services.permanence.mespermanences.UnePeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PermanenceCellDTO;
import fr.amapj.view.engine.grid.GridHeaderLine;
import fr.amapj.view.engine.grid.GridSizeCalculator;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.permanence.mespermanences.MesPermanencesUtils;
import fr.amapj.view.views.permanence.mespermanences.grille.InscriptionPopup;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class InscriptionPopupRoleDifferent
extends CorePopup {
    private PeriodePermanenceDateDTO dateDto;
    private Long userId;
    private Long idPeriodePermanence;
    private VerticalLayout contentLayout;
    private Long idPeriodePermanenceDate;
    private UnePeriodePermanenceDTO periodePermanenceDTO;

    public InscriptionPopupRoleDifferent(Long idPeriodePermanenceDate, Long userId, Long idPeriodePermanence) {
        this.idPeriodePermanenceDate = idPeriodePermanenceDate;
        this.userId = userId;
        this.idPeriodePermanence = idPeriodePermanence;
        this.popupTitle = "S'inscrire";
        this.setWidth(40, 850);
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.contentLayout = contentLayout;
        contentLayout.addStyleName("grille-permanence");
        this.refresh();
    }

    private void refresh() {
        this.contentLayout.removeAllComponents();
        this.dateDto = new PeriodePermanenceService().loadOneDatePermanence(this.idPeriodePermanenceDate);
        this.periodePermanenceDTO = new MesPermanencesService().loadCompteurPeriodePermanence(this.idPeriodePermanence, this.userId);
        String cpt = MesPermanencesUtils.getLibCompteur(this.periodePermanenceDTO);
        boolean couldSubscribeMore = MesPermanencesUtils.couldSubcribeMore(this.periodePermanenceDTO);
        Tab tab = this.createTab(couldSubscribeMore);
        BaseUiTools.addHtmlLabel((Layout)this.contentLayout, cpt, "compteur");
        this.drawTab(tab);
    }

    private Tab createTab(boolean couldSubscribeMore) {
        Tab tab = new Tab();
        SimpleDateFormat df = FormatUtils.getFullDate();
        tab.titre = df.format(this.dateDto.datePerm);
        tab.styleTitre = this.dateDto.isDateComplete() ? "date-complete" : "date-avec-dispo";
        List<RoleLine> roles = this.computeRoleLine();
        for (RoleLine role : roles) {
            Tab.TabLine line = new Tab.TabLine();
            line.role = role;
            line.col1 = role.nomRole;
            line.styleCol1 = "role";
            int nbPlacesDispo = role.nbPlaceDispo;
            String str = "Aucune place disponible";
            if (nbPlacesDispo > 1) {
                str = String.valueOf(nbPlacesDispo) + " places disponibles";
            } else if (nbPlacesDispo == 1) {
                str = "Une place disponible";
            }
            line.col2 = str;
            line.styleCol2 = "role";
            String str2 = CollectionUtils.asString(role.utilisateurs, ", ");
            if (role.isInscrit) {
                line.col3 = str2;
                line.styleCol3 = "place-moi";
                line.col4 = "Je ne souhaite plus venir";
                line.styleCol4 = "suppress-inscrire";
            } else if (nbPlacesDispo == 0) {
                line.col3 = str2;
                line.styleCol3 = "place-occupee";
            } else {
                line.col3 = str2;
                line.styleCol3 = "place-libre";
                if (couldSubscribeMore) {
                    line.col4 = "Je m'inscris";
                    line.styleCol4 = "inscrire";
                }
            }
            tab.lines.add(line);
        }
        return tab;
    }

    private List<RoleLine> computeRoleLine() {
        ArrayList<RoleLine> roles = new ArrayList<RoleLine>();
        for (PermanenceCellDTO cell : this.dateDto.permanenceCellDTOs) {
            RoleLine line = this.findOrCreate(roles, cell.idRole, cell.nomRole);
            if (LongUtils.equals(cell.idUtilisateur, this.userId)) {
                line.isInscrit = true;
            }
            if (cell.idUtilisateur != null) {
                line.utilisateurs.add(String.valueOf(cell.nom) + " " + cell.prenom);
                continue;
            }
            ++line.nbPlaceDispo;
        }
        return roles;
    }

    private RoleLine findOrCreate(List<RoleLine> roles, Long idRole, String nomRole) {
        RoleLine roleLine2;
        for (RoleLine roleLine2 : roles) {
            if (!LongUtils.equals(roleLine2.idRole, idRole)) continue;
            return roleLine2;
        }
        roleLine2 = new RoleLine();
        roleLine2.idRole = idRole;
        roleLine2.nomRole = nomRole;
        roles.add(roleLine2);
        return roleLine2;
    }

    private void handleButton(RoleLine roleLine) {
        if (!roleLine.isInscrit) {
            MesPermanencesService.InscriptionMessage msg = new MesPermanencesService().inscription(this.userId, this.idPeriodePermanenceDate, roleLine.idRole, RegleInscriptionPeriodePermanence.MULTIPLE_INSCRIPTION_SUR_ROLE_DIFFERENT);
            if (msg != null) {
                String lib = InscriptionPopup.computeLib(msg);
                MessagePopup popup = new MessagePopup("Impossible de s'inscrire", CorePopup.ColorStyle.RED, "Vous ne pouvez pas vous inscrire car " + lib);
                MessagePopup.open(popup);
            }
        } else {
            new MesPermanencesService().deleteInscriptionRoleDifferent(this.userId, this.idPeriodePermanenceDate, roleLine.idRole);
        }
        this.refresh();
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.addButton("OK", (Button.ClickListener & Serializable)e -> this.close());
    }

    public void drawTab(Tab tab) {
        GridLayout gl = new GridLayout(4, 1 + tab.lines.size());
        gl.setWidth("800px");
        gl.setSpacing(false);
        this.contentLayout.addComponent((Component)gl);
        Label l = new Label(tab.titre);
        l.addStyleName(tab.styleTitre);
        l.setWidth("100%");
        gl.addComponent((Component)l, 0, 0, 3, 0);
        List<Tab.TabLine> lines = tab.lines;
        int i = 0;
        while (i < lines.size()) {
            Tab.TabLine line = lines.get(i);
            int height = this.computeHeight(line);
            height = Math.max(height, 36);
            Label l1 = new Label(line.col1);
            l1.addStyleName(line.styleCol1);
            l1.setWidth("100%");
            l1.setHeight(String.valueOf(height) + "px");
            gl.addComponent((Component)l1, 0, i + 1);
            Label l2 = new Label(line.col2);
            l2.addStyleName(line.styleCol2);
            l2.setWidth("100%");
            l2.setHeight(String.valueOf(height) + "px");
            gl.addComponent((Component)l2, 1, i + 1);
            Label l3 = new Label(line.col3);
            l3.addStyleName(line.styleCol3);
            l3.setWidth("100%");
            l3.setHeight(String.valueOf(height) + "px");
            gl.addComponent((Component)l3, 2, i + 1);
            if (line.col4 != null) {
                Button b = new Button(line.col4);
                b.addStyleName(line.styleCol4);
                b.addClickListener((Button.ClickListener & Serializable)e -> this.handleButton(tabLine.role));
                b.setWidth("100%");
                gl.addComponent((Component)b, 3, i + 1);
                gl.setComponentAlignment((Component)b, Alignment.MIDDLE_CENTER);
            } else {
                Label l4 = new Label("");
                l4.addStyleName(line.styleCol4);
                l4.setWidth("100%");
                l4.setHeight(String.valueOf(height) + "px");
                gl.addComponent((Component)l4, 3, i + 1);
            }
            ++i;
        }
    }

    private int computeHeight(Tab.TabLine line) {
        int cellWidth = 200;
        GridHeaderLine gridHeaderLine = new GridHeaderLine();
        gridHeaderLine.addCell(line.col1);
        gridHeaderLine.addCell(line.col2);
        gridHeaderLine.addCell(line.col3);
        GridSizeCalculator.autoSize(gridHeaderLine, cellWidth, "Arial", 16);
        return gridHeaderLine.height;
    }

    public static class RoleLine {
        public Long idRole;
        public String nomRole;
        public int nbPlaceDispo;
        public List<String> utilisateurs = new ArrayList<String>();
        public boolean isInscrit = false;
    }

    public static class Tab {
        public String titre;
        public String styleTitre;
        public List<TabLine> lines = new ArrayList<TabLine>();

        public static class TabLine {
            public RoleLine role;
            public String col1;
            public String styleCol1;
            public String col2;
            public String styleCol2;
            public String col3;
            public String styleCol3;
            public String col4;
            public String styleCol4;
        }
    }
}

