/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.mespermanences.grille;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.LongUtils;
import fr.amapj.service.services.permanence.mespermanences.MesPermanencesService;
import fr.amapj.service.services.permanence.mespermanences.UnePeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PermanenceCellDTO;
import fr.amapj.view.engine.grid.GridHeaderLine;
import fr.amapj.view.engine.grid.GridSizeCalculator;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.permanence.mespermanences.MesPermanencesUtils;
import fr.amapj.view.views.permanence.mespermanences.grille.InscriptionPopup;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class InscriptionPopupToutAutorise
extends CorePopup {
    private PeriodePermanenceDateDTO dateDto;
    private Long userId;
    private Long idPeriodePermanence;
    private VerticalLayout contentLayout;
    private Long idPeriodePermanenceDate;
    private UnePeriodePermanenceDTO periodePermanenceDTO;

    public InscriptionPopupToutAutorise(Long idPeriodePermanenceDate, Long userId, Long idPeriodePermanence) {
        this.idPeriodePermanenceDate = idPeriodePermanenceDate;
        this.userId = userId;
        this.idPeriodePermanence = idPeriodePermanence;
        this.popupTitle = "S'inscrire";
        this.setWidth(40, 650);
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.contentLayout = contentLayout;
        contentLayout.addStyleName("grille-permanence");
        this.refresh();
    }

    private void refresh() {
        this.contentLayout.removeAllComponents();
        this.dateDto = new PeriodePermanenceService().loadOneDatePermanence(this.idPeriodePermanenceDate);
        this.periodePermanenceDTO = new MesPermanencesService().loadCompteurPeriodePermanence(this.idPeriodePermanence, this.userId);
        String cpt = MesPermanencesUtils.getLibCompteur(this.periodePermanenceDTO);
        boolean couldSubscribeMore = MesPermanencesUtils.couldSubcribeMore(this.periodePermanenceDTO);
        Tab tab = this.createTab(couldSubscribeMore);
        BaseUiTools.addHtmlLabel((Layout)this.contentLayout, cpt, "compteur");
        this.drawTab(tab);
    }

    private Tab createTab(boolean couldSubscribeMore) {
        Tab tab = new Tab();
        SimpleDateFormat df = FormatUtils.getFullDate();
        tab.titre = df.format(this.dateDto.datePerm);
        tab.styleTitre = this.dateDto.isDateComplete() ? "date-complete" : "date-avec-dispo";
        for (PermanenceCellDTO pc : this.dateDto.permanenceCellDTOs) {
            Tab.TabLine line = new Tab.TabLine();
            line.cell = pc;
            line.col1 = pc.lib;
            line.styleCol1 = "role";
            if (LongUtils.equals(pc.idUtilisateur, this.userId)) {
                line.col2 = String.valueOf(pc.nom) + " " + pc.prenom;
                line.styleCol2 = "place-moi";
                line.col3 = "Je ne souhaite plus venir";
                line.styleCol3 = "suppress-inscrire";
            } else if (pc.idUtilisateur != null) {
                line.col2 = String.valueOf(pc.nom) + " " + pc.prenom;
                line.styleCol2 = "place-occupee";
            } else {
                line.col2 = "Place libre";
                line.styleCol2 = "place-libre";
                if (couldSubscribeMore) {
                    line.col3 = "Je m'inscris";
                    line.styleCol3 = "inscrire";
                }
            }
            tab.lines.add(line);
        }
        return tab;
    }

    private void handleButton(PermanenceCellDTO cell) {
        if (cell.idUtilisateur == null) {
            MesPermanencesService.InscriptionMessage msg = new MesPermanencesService().inscriptionToutAutorise(this.userId, cell.idPermanenceCell, this.idPeriodePermanenceDate);
            if (msg != null) {
                String lib = InscriptionPopup.computeLib(msg);
                MessagePopup popup = new MessagePopup("Impossible de s'inscrire", CorePopup.ColorStyle.RED, "Vous ne pouvez pas vous inscrire car " + lib);
                MessagePopup.open(popup);
            }
        } else if (LongUtils.equals(cell.idUtilisateur, this.userId)) {
            new MesPermanencesService().deleteInscriptionToutAutorise(this.userId, cell.idPermanenceCell, this.idPeriodePermanenceDate);
        }
        this.refresh();
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.addButton("OK", (Button.ClickListener & Serializable)e -> this.close());
    }

    public void drawTab(Tab tab) {
        GridLayout gl = new GridLayout(3, 1 + tab.lines.size());
        gl.setWidth("600px");
        gl.setSpacing(false);
        this.contentLayout.addComponent((Component)gl);
        Label l = new Label(tab.titre);
        l.addStyleName(tab.styleTitre);
        l.setWidth("100%");
        gl.addComponent((Component)l, 0, 0, 2, 0);
        List<Tab.TabLine> lines = tab.lines;
        int i = 0;
        while (i < lines.size()) {
            Tab.TabLine line = lines.get(i);
            int height = this.computeHeight(line);
            height = Math.max(height, 36);
            Label l1 = new Label(line.col1);
            l1.addStyleName(line.styleCol1);
            l1.setWidth("100%");
            l1.setHeight(String.valueOf(height) + "px");
            gl.addComponent((Component)l1, 0, i + 1);
            Label l2 = new Label(line.col2);
            l2.addStyleName(line.styleCol2);
            l2.setWidth("100%");
            l2.setHeight(String.valueOf(height) + "px");
            gl.addComponent((Component)l2, 1, i + 1);
            if (line.col3 != null) {
                Button b = new Button(line.col3);
                b.addStyleName(line.styleCol3);
                b.addClickListener((Button.ClickListener & Serializable)e -> this.handleButton(tabLine.cell));
                b.setWidth("100%");
                gl.addComponent((Component)b, 2, i + 1);
                gl.setComponentAlignment((Component)b, Alignment.MIDDLE_CENTER);
            } else {
                Label l3 = new Label("");
                l3.addStyleName(line.styleCol3);
                l3.setWidth("100%");
                l3.setHeight(String.valueOf(height) + "px");
                gl.addComponent((Component)l3, 2, i + 1);
            }
            ++i;
        }
    }

    private int computeHeight(Tab.TabLine line) {
        int cellWidth = 200;
        GridHeaderLine gridHeaderLine = new GridHeaderLine();
        gridHeaderLine.addCell(line.col1);
        gridHeaderLine.addCell(line.col2);
        GridSizeCalculator.autoSize(gridHeaderLine, cellWidth, "Arial", 16);
        return gridHeaderLine.height;
    }

    public static class Tab {
        public String titre;
        public String styleTitre;
        public List<TabLine> lines = new ArrayList<TabLine>();

        public static class TabLine {
            public PermanenceCellDTO cell;
            public String col1;
            public String styleCol1;
            public String col2;
            public String styleCol2;
            public String col3;
            public String styleCol3;
        }
    }
}

