/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.mespermanences.small;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.DateUtils;
import fr.amapj.common.GenericUtils;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.tools.BaseUiTools;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class DatePerDateViewer<T> {
    private SimpleDateFormat df1 = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
    private SimpleDateFormat df2 = new SimpleDateFormat("dd/MM/yy");
    private Label titre;
    private int currentIndex;
    private GenericUtils.ToDate<T> toDate;
    private PopupListener listener;
    private List<T> dates;
    private Button previous;
    private Button next;

    public DatePerDateViewer(List<T> dates, GenericUtils.ToDate<T> toDate, PopupListener listener) {
        this.dates = dates;
        this.toDate = toDate;
        this.currentIndex = 0;
        this.listener = listener;
    }

    public VerticalLayout getComponent() {
        VerticalLayout vl = new VerticalLayout();
        vl.setMargin(false);
        vl.setSpacing(false);
        vl.addStyleName("date-viewer");
        HorizontalLayout hl1 = new HorizontalLayout();
        hl1.setWidth("100%");
        this.previous = this.addButton(false, hl1, (Button.ClickListener & Serializable)e -> this.reculer());
        Label empty = new Label();
        hl1.addComponent((Component)empty);
        hl1.setExpandRatio((Component)empty, 1.0f);
        this.next = this.addButton(true, hl1, (Button.ClickListener & Serializable)e -> this.avancer());
        vl.addComponent((Component)hl1);
        this.titre = new Label();
        hl1.addStyleName("titre");
        this.titre.setSizeUndefined();
        vl.addComponent((Component)this.titre);
        vl.setComponentAlignment((Component)this.titre, Alignment.MIDDLE_CENTER);
        this.updateButtonState();
        return vl;
    }

    private void updateButtonState() {
        this.previous.setEnabled(this.currentIndex != 0);
        this.next.setEnabled(this.currentIndex != this.dates.size() - 1);
        Date toDisplay = this.toDate.toDate(this.dates.get(this.currentIndex));
        SimpleDateFormat dfx = BaseUiTools.isWidthBelow(480) ? this.df2 : this.df1;
        this.titre.setValue(dfx.format(toDisplay));
    }

    private void avancer() {
        if (this.currentIndex < this.dates.size() - 1) {
            ++this.currentIndex;
            this.updateButtonState();
            this.listener.onPopupClose();
        }
    }

    private void reculer() {
        if (this.currentIndex > 0) {
            --this.currentIndex;
            this.updateButtonState();
            this.listener.onPopupClose();
        }
    }

    private Button addButton(boolean toRight, HorizontalLayout layout, Button.ClickListener listener) {
        String str = toRight ? "SUIVANT" : "PRECEDENT";
        Button b = new Button(str);
        b.addClickListener(listener);
        if (toRight) {
            b.setIcon((Resource)FontAwesome.ANGLE_DOUBLE_RIGHT);
            b.addStyleName("icon-align-right");
            b.addStyleName("large");
        } else {
            b.setIcon((Resource)FontAwesome.ANGLE_DOUBLE_LEFT);
            b.addStyleName("large");
        }
        b.addStyleName("fleche");
        layout.addComponent((Component)b);
        return b;
    }

    public void updateTitreValue(Date dateDebut, Date dateFin) {
        SimpleDateFormat dfx = BaseUiTools.isWidthBelow(480) ? this.df2 : this.df1;
        this.titre.setValue(String.valueOf(dfx.format(dateDebut)) + " - " + dfx.format(dateFin));
    }

    public T getDate() {
        return this.dates.get(this.currentIndex);
    }

    public void updateDates(List<T> newDates) {
        Date oldDate = this.toDate.toDate(this.dates.get(this.currentIndex));
        Date newDate = null;
        if (this.currentIndex < newDates.size()) {
            newDate = this.toDate.toDate(newDates.get(this.currentIndex));
        }
        if (!DateUtils.equals(oldDate, newDate)) {
            this.currentIndex = 0;
        }
        this.dates.clear();
        this.dates.addAll(newDates);
    }
}

