/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.mespermanences.small;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.model.models.permanence.periode.RegleInscriptionPeriodePermanence;
import fr.amapj.service.services.permanence.mespermanences.MesPermanencesService;
import fr.amapj.service.services.permanence.mespermanences.UnePeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PermanenceCellDTO;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.popup.okcancelpopup.OKCancelPopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.permanence.mespermanences.MesPermanencesUtils;
import fr.amapj.view.views.permanence.mespermanences.grille.InscriptionPopup;
import fr.amapj.view.views.permanence.mespermanences.small.DatePerDateViewer;
import java.io.Serializable;

public class SmallInscriptionPermanence
extends OKCancelPopup
implements PopupListener {
    private Long userId;
    private PeriodePermanenceDTO dto;
    private UnePeriodePermanenceDTO periodePermanenceDTO;
    private VerticalLayout compteur;
    private VerticalLayout planning;
    private DatePerDateViewer<PeriodePermanenceDateDTO> dateViewer;
    private boolean visualiser;

    public SmallInscriptionPermanence(Long idPeriodePermanence, Long userId, boolean visualiser) {
        this.userId = userId;
        this.visualiser = visualiser;
        this.dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(idPeriodePermanence);
        this.popupTitle = visualiser ? "Visualisation des permanences" : "Choix des permanences";
        this.hasSaveButton = false;
        this.cancelButtonTitle = "OK";
        this.computeSouhaiteeReelle();
    }

    private void computeSouhaiteeReelle() {
        this.periodePermanenceDTO = new MesPermanencesService().loadCompteurPeriodePermanence(this.dto.id, this.userId);
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.compteur = new VerticalLayout();
        this.compteur.addStyleName("popup-choix-permanence");
        contentLayout.addComponent((Component)this.compteur);
        this.dateViewer = new DatePerDateViewer<PeriodePermanenceDateDTO>(this.dto.datePerms, e -> e.datePerm, this);
        contentLayout.addComponent((Component)this.dateViewer.getComponent());
        VerticalLayout central = new VerticalLayout();
        contentLayout.addComponent((Component)central);
        this.planning = new VerticalLayout();
        this.planning.addStyleName("popup-choix-permanence");
        central.addComponent((Component)this.planning);
        this.onPopupClose();
    }

    @Override
    protected boolean performSauvegarder() {
        return true;
    }

    @Override
    public void onPopupClose() {
        this.compteur.removeAllComponents();
        if (!this.visualiser) {
            String cpt = MesPermanencesUtils.getLibCompteur(this.periodePermanenceDTO);
            BaseUiTools.addHtmlLabel((Layout)this.compteur, cpt, "compteur");
        }
        this.planning.removeAllComponents();
        PeriodePermanenceDateDTO detail = this.dateViewer.getDate();
        String msg = this.getMessageListeInscrit(detail);
        BaseUiTools.addHtmlLabel((Layout)this.planning, msg, "liste-inscrits");
        boolean isModifiable = MesPermanencesUtils.isDateModifiable(this.periodePermanenceDTO, detail);
        if (this.visualiser) {
            this.doVisualiserPart(detail, isModifiable);
        } else if (isModifiable) {
            this.doModifierPart(detail);
        } else {
            this.doVisualiserPart(detail, isModifiable);
        }
    }

    private void doVisualiserPart(PeriodePermanenceDateDTO detail, boolean isModifiable) {
        boolean isInscrit = detail.isInscrit(this.userId);
        boolean placeDispo = this.isPlaceDispo(detail);
        if (isModifiable) {
            BaseUiTools.addHtmlLabel((Layout)this.planning, "Il est encore possible de modifier ses choix sur cette date", "place-dispo");
        } else {
            BaseUiTools.addHtmlLabel((Layout)this.planning, "Il n'est plus possible de modifier ses choix sur cette date", "place-dispo");
        }
        if (isInscrit) {
            BaseUiTools.addHtmlLabel((Layout)this.planning, "Vous \u00eates inscrit pour cette permanence.", "place-dispo");
            return;
        }
        if (!placeDispo) {
            BaseUiTools.addHtmlLabel((Layout)this.planning, "Il n'y a plus de place disponible \u00e0 cette date.", "place-dispo");
            return;
        }
    }

    private void doModifierPart(PeriodePermanenceDateDTO detail) {
        boolean isInscrit = detail.isInscrit(this.userId);
        boolean placeDispo = this.isPlaceDispo(detail);
        if (isInscrit) {
            BaseUiTools.addHtmlLabel((Layout)this.planning, "Vous \u00eates inscrit pour cette permanence.", "place-dispo");
            Button b = new Button("Je ne souhaite plus venir \u00e0 cette date.");
            b.addStyleName("suppress-inscrire");
            b.addClickListener((Button.ClickListener & Serializable)e -> this.handleSuppressionInscription(detail));
            this.planning.addComponent((Component)b);
            this.planning.setComponentAlignment((Component)b, Alignment.MIDDLE_CENTER);
            return;
        }
        if (!placeDispo) {
            BaseUiTools.addHtmlLabel((Layout)this.planning, "Il n'y a plus de place disponible \u00e0 cette date.", "place-dispo");
            return;
        }
        Button b = new Button("Je m'inscris \u00e0 cette date");
        b.addStyleName("inscrire");
        b.addClickListener((Button.ClickListener & Serializable)e -> this.handleInscription(detail));
        this.planning.addComponent((Component)b);
        this.planning.setComponentAlignment((Component)b, Alignment.MIDDLE_CENTER);
    }

    private boolean isPlaceDispo(PeriodePermanenceDateDTO detail) {
        int nbPlace = detail.nbPlace - detail.getNbInscrit();
        return nbPlace > 0;
    }

    private String getMessageListeInscrit(PeriodePermanenceDateDTO detail) {
        String msg = "";
        if (detail.nbPlace == 0) {
            msg = String.valueOf(msg) + "Pas de permanence ce jour l\u00e0.";
            return msg;
        }
        msg = detail.nbPlace == 1 ? String.valueOf(msg) + "1 personne est n\u00e9cessaire pour cette permanence." : String.valueOf(msg) + detail.nbPlace + " personnes sont n\u00e9cessaires pour cette permanence.";
        msg = String.valueOf(msg) + "<br/>";
        msg = detail.getNbInscrit() == 0 ? String.valueOf(msg) + "Personne n'est encore inscrit." : (detail.getNbInscrit() == 1 ? String.valueOf(msg) + "Une personne est inscrite :" : String.valueOf(msg) + detail.getNbInscrit() + " personnes sont inscrites.");
        msg = String.valueOf(msg) + "<ul>";
        for (PermanenceCellDTO pc : detail.permanenceCellDTOs) {
            msg = String.valueOf(msg) + "<li>" + "Role " + pc.nomRole + " - " + pc.nom + " " + pc.prenom + "</li>";
        }
        msg = String.valueOf(msg) + "</ul>";
        return msg;
    }

    private void handleInscription(PeriodePermanenceDateDTO detail) {
        if (this.periodePermanenceDTO.nbInscription >= this.periodePermanenceDTO.nbSouhaite) {
            MessagePopup popup = new MessagePopup("Impossible de s'inscrire", CorePopup.ColorStyle.GREEN, "Vous \u00eates d\u00e9j\u00e0 inscrit sur suffisamment de dates.");
            MessagePopup.open(popup);
            return;
        }
        MesPermanencesService.InscriptionMessage msg = new MesPermanencesService().inscription(this.userId, detail.idPeriodePermanenceDate, null, RegleInscriptionPeriodePermanence.UNE_INSCRIPTION_PAR_DATE);
        if (msg != null) {
            String lib = InscriptionPopup.computeLib(msg);
            MessagePopup popup = new MessagePopup("Impossible de s'inscrire", CorePopup.ColorStyle.RED, "Vous ne pouvez pas vous inscrire car " + lib);
            MessagePopup.open(popup, () -> this.handleFinInscription());
        } else {
            this.handleFinInscription();
        }
    }

    private void handleFinInscription() {
        this.dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(this.dto.id);
        this.dateViewer.updateDates(this.dto.datePerms);
        this.computeSouhaiteeReelle();
        this.onPopupClose();
    }

    private void handleSuppressionInscription(PeriodePermanenceDateDTO detail) {
        new MesPermanencesService().deleteInscription(this.userId, detail.idPeriodePermanenceDate);
        this.handleFinInscription();
    }
}

