/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.periode;

import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.SmallPeriodePermanenceDTO;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.engine.popup.swicthpopup.SwitchPopup;
import fr.amapj.view.views.permanence.periode.PeriodePermanenceCreationEditorPart;
import fr.amapj.view.views.permanence.periode.PeriodePermanenceModifEtat;
import fr.amapj.view.views.permanence.periode.PeriodePermanenceVisualiserPart;
import fr.amapj.view.views.permanence.periode.grille.ModifierPeriodePermanenceGrillePart;
import fr.amapj.view.views.permanence.periode.grille.VisualiserPeriodePermanenceGrillePart;
import fr.amapj.view.views.permanence.periode.update.PopupAddDateForPeriodePermanence;
import fr.amapj.view.views.permanence.periode.update.PopupAddUtilisateurForPeriodePermanence;
import fr.amapj.view.views.permanence.periode.update.PopupDeleteDateForPeriodePermanence;
import fr.amapj.view.views.permanence.periode.update.PopupDeleteUtilisateurForPeriodePermanence;
import fr.amapj.view.views.permanence.periode.update.PopupModifEnteteForPeriodePermanence;
import fr.amapj.view.views.permanence.periode.update.PopupRegleInscriptionPeriodePermanence;
import fr.amapj.view.views.permanence.periode.update.PopupUpdateAllRole;
import fr.amapj.view.views.permanence.periode.update.PopupUpdateNbParticipationForPeriodePermanence;
import java.util.List;

public class PeriodePermanenceListPart
extends StandardListPart<SmallPeriodePermanenceDTO> {
    public PeriodePermanenceListPart() {
        super(SmallPeriodePermanenceDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des p\u00e9riodes de permanences";
    }

    @Override
    protected void drawButton() {
        this.addButton("Cr\u00e9er une nouvelle p\u00e9riode", ButtonType.ALWAYS, e -> new PeriodePermanenceCreationEditorPart());
        this.addButton("Visualiser grille", ButtonType.EDIT_MODE, e -> new VisualiserPeriodePermanenceGrillePart(e.id, null));
        this.addButton("Visualiser d\u00e9tail", ButtonType.EDIT_MODE, e -> new PeriodePermanenceVisualiserPart(e.id));
        this.addButton("Modifier grille", ButtonType.EDIT_MODE, e -> new ModifierPeriodePermanenceGrillePart(e.id));
        this.addButton("Modifier ...", ButtonType.EDIT_MODE, e -> this.handleModifier(e.id));
        this.addButton("Changer l'\u00e9tat", ButtonType.EDIT_MODE, e -> new PeriodePermanenceModifEtat((SmallPeriodePermanenceDTO)e));
        this.addButton("Supprimer", ButtonType.EDIT_MODE, e -> this.handleSupprimer());
        this.addSearchField("Rechercher par nom");
    }

    @Override
    protected void drawTable() {
        this.addColumn("etat", "Etat");
        this.addColumn("nom", "Nom de la p\u00e9riode");
        this.addColumnDate("dateDebut", "Date de d\u00e9but");
        this.addColumnDate("dateFin", "Date de fin");
        this.addColumn("nbDatePerm", "Nombre de dates");
        this.addColumn("pourcentageInscription", "% Inscription");
    }

    @Override
    protected List<SmallPeriodePermanenceDTO> getLines() {
        return new PeriodePermanenceService().getAllPeriodePermanence();
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nom"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom"};
    }

    private CorePopup handleModifier(Long idPeriodePermanence) {
        SwitchPopup popup = new SwitchPopup("Modifications des p\u00e9riodes de permanence", 50);
        popup.addLine("Modifier le nom, la description, la date de fin des inscriptions", () -> new PopupModifEnteteForPeriodePermanence(idPeriodePermanence));
        popup.addSeparator();
        popup.addLine("Ajouter des dates de permanences", () -> new PopupAddDateForPeriodePermanence(idPeriodePermanence));
        popup.addLine("Supprimer des dates de permanences", () -> new PopupDeleteDateForPeriodePermanence(idPeriodePermanence));
        popup.addSeparator();
        popup.addLine("Ajouter des participants", () -> new PopupAddUtilisateurForPeriodePermanence(idPeriodePermanence));
        popup.addLine("Supprimer des participants", () -> new PopupDeleteUtilisateurForPeriodePermanence(idPeriodePermanence));
        popup.addLine("Modifier le nombre de participations", () -> new PopupUpdateNbParticipationForPeriodePermanence(idPeriodePermanence));
        popup.addSeparator();
        popup.addLine("Positionner les r\u00f4les pour toutes les dates en masse", () -> new PopupUpdateAllRole(idPeriodePermanence));
        popup.addSeparator();
        popup.addLine("Modifier les r\u00e9gles d'inscriptions", () -> new PopupRegleInscriptionPeriodePermanence(idPeriodePermanence));
        return popup;
    }

    protected SuppressionPopup handleSupprimer() {
        SmallPeriodePermanenceDTO dto = (SmallPeriodePermanenceDTO)this.getSelectedLine();
        String text = "Etes vous s\u00fbr de vouloir supprimer la p\u00e9riode de permanence " + dto.nom + " ?";
        return new SuppressionPopup(text, dto.id, e -> new PeriodePermanenceService().deletePeriodePermanence((Long)e));
    }
}

