/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.periode;

import com.vaadin.ui.ComboBox;
import fr.amapj.model.models.permanence.periode.NaturePeriodePermanence;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceUtilisateurDTO;
import fr.amapj.view.engine.collectioneditor.CollectionEditor;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import fr.amapj.view.views.permanence.periode.PeriodePermanenceCreationEditorPart;

public class PeriodePermanenceVisualiserPart
extends WizardFormPopup {
    protected PeriodePermanenceDTO dto;
    private ComplexTableBuilder<PeriodePermanenceUtilisateurDTO> builder;

    @Override
    protected void configure() {
        this.add(() -> this.drawInfoGenerales());
        this.add(() -> this.drawDetailDate());
        this.add(() -> this.drawDetailParticipants());
        this.add(() -> this.addFieldBilan());
    }

    public PeriodePermanenceVisualiserPart(Long idPeriodePermanence) {
        this.setWidth(80);
        this.saveButtonTitle = "OK";
        this.popupTitle = "Visualisation d'une p\u00e9riode de permanence";
        this.dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(idPeriodePermanence);
        this.setModel(this.dto);
    }

    private void drawInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales de cette p\u00e9riode de permanence");
        this.addTextField("Nom de la p\u00e9riode de permanence", "nom", new IValidator[0]).setReadOnly(true);
        this.addTextField("Description de la p\u00e9riode", "description", new IValidator[0]).setReadOnly(true);
        this.addComboEnumField("Nature de la p\u00e9riode", "nature", new IValidator[0]).setReadOnly(true);
        ComboBox box = this.addComboEnumField("R\u00e9gle d'inscription sur une date", "regleInscription", new IValidator[0]);
        box.setReadOnly(true);
        box.setWidth("600px");
        this.addComboEnumField("D\u00e9passement autoris\u00e9", "depassementAutorise", PeriodePermanenceCreationEditorPart.helpDepassementAutorise).setReadOnly(true);
        this.addDateField("Date de la premi\u00e8re permanence", "dateDebut", new IValidator[0]).setReadOnly(true);
        this.addDateField("Date de la derni\u00e8re permanence", "dateFin", new IValidator[0]).setReadOnly(true);
        if (this.dto.nature == NaturePeriodePermanence.INSCRIPTION_LIBRE_FLOTTANT) {
            this.addIntegerField("D\u00e9lai en jour pour modification de son affectation avant permanence", "flottantDelai", new IValidator[0]).setReadOnly(true);
        } else if (this.dto.nature == NaturePeriodePermanence.INSCRIPTION_LIBRE_AVEC_DATE_LIMITE) {
            this.addDateField("Date de fin des inscriptions", "dateFinInscription", new IValidator[0]).setReadOnly(true);
        }
    }

    private void drawDetailDate() {
        this.setStepTitle("d\u00e9tails des dates de permanences");
        CollectionEditor<PeriodePermanenceDateDTO> f1 = this.addCollectionEditorField("Dates", "datePerms", PeriodePermanenceDateDTO.class, new IValidator[0]);
        f1.addColumn("datePerm", "Date permanence", FieldType.DATE, false, null);
        f1.addColumn("nbPlace", "Nb de personnes", FieldType.QTE, false, null);
        f1.disableAllButtons();
    }

    private void drawDetailParticipants() {
        this.setStepTitle("d\u00e9tails des participants aux permanences");
        this.builder = new ComplexTableBuilder<PeriodePermanenceUtilisateurDTO>(this.dto.utilisateurs);
        this.builder.setPageLength(14);
        this.builder.addString("Nom", false, 300, e -> e.nom);
        this.builder.addString("Pr\u00e9nom", false, 300, e -> e.prenom);
        this.builder.addString("Nb de participations", false, 100, e -> e.nbParticipation);
        this.addComplexTable(this.builder);
    }

    private void addFieldBilan() {
        this.setStepTitle("bilan");
        String bilan = new PeriodePermanenceService().computeBilan(this.dto);
        this.addHtml(bilan);
    }

    @Override
    protected void performSauvegarder() {
    }
}

