/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.periode.grille;

import fr.amapj.common.FormatUtils;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.permanence.detailperiode.DetailPeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PermanenceCellDTO;
import fr.amapj.service.services.permanence.role.PermanenceRoleService;
import fr.amapj.view.engine.collectioneditor.CollectionEditor;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.views.searcher.SDUtilisateurPermanence;
import fr.amapj.view.views.searcher.SearcherList;
import java.util.List;

public class PopupModifRoleUtilisateur
extends WizardFormPopup {
    PeriodePermanenceDateDTO dto;

    public PopupModifRoleUtilisateur(Long idPeriodePermanenceDate) {
        this.setWidth(80);
        this.dto = new PeriodePermanenceService().loadOneDatePermanence(idPeriodePermanenceDate);
        this.setModel(this.dto);
        this.popupTitle = "Modification du " + FormatUtils.getFullDate().format(this.dto.datePerm);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldUtilisateurs(), () -> this.checkFieldUtilisateur());
    }

    private void addFieldUtilisateurs() {
        this.setStepTitle("les r\u00f4les et les personnes de permanence");
        List<Utilisateur> allowed = new DetailPeriodePermanenceService().computeAllowedUser(this.dto.idPeriodePermanenceDate);
        SDUtilisateurPermanence searcher = new SDUtilisateurPermanence(allowed);
        Long idDefaultRole = new PermanenceRoleService().getIdDefaultRole();
        CollectionEditor<PermanenceCellDTO> f1 = this.addCollectionEditorField("", "permanenceCellDTOs", PermanenceCellDTO.class, new IValidator[0]);
        f1.addSearcherColumn("idRole", "Role", FieldType.SEARCHER, idDefaultRole, SearcherList.PERIODE_PERMANENCE_ROLE, null);
        f1.addSearcherColumn("idUtilisateur", "Adh\u00e9rent", FieldType.SEARCHER, null, searcher, null);
    }

    private String checkFieldUtilisateur() {
        int i = 0;
        while (i < this.dto.permanenceCellDTOs.size()) {
            PermanenceCellDTO lig = this.dto.permanenceCellDTOs.get(i);
            if (lig.idRole == null) {
                return "Il faut d\u00e9finir un r\u00f4le \u00e0 la ligne " + (i + 1);
            }
            ++i;
        }
        return this.dto.checkRegleInscription();
    }

    private boolean isPresent(Long idUtilisateur, List<PermanenceCellDTO> permanenceCellDTOs, int indexNotToCheck) {
        int i = 0;
        while (i < this.dto.permanenceCellDTOs.size()) {
            PermanenceCellDTO lig = this.dto.permanenceCellDTOs.get(i);
            if (i != indexNotToCheck && lig.idUtilisateur == idUtilisateur) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected void performSauvegarder() {
        new DetailPeriodePermanenceService().updateRoleAndUtilisateur(this.dto);
    }
}

