/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.periode.update;

import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.update.PeriodePermanenceUpdateService;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import java.util.List;

public class PopupDeleteDateForPeriodePermanence
extends WizardFormPopup {
    protected PeriodePermanenceDTO dto;
    private List<PeriodePermanenceDateDTO> existingDatePerms;

    public PopupDeleteDateForPeriodePermanence(Long id) {
        this.popupTitle = "Supprimer des dates \u00e0 une p\u00e9riode de permanence";
        this.setWidth(80);
        this.dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(id);
        this.dto.dateDebut = null;
        this.dto.dateFin = null;
        this.setModel(this.dto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.infos());
        this.add(() -> this.saisieDate(), () -> this.checkDates());
        this.add(() -> this.confirmation());
    }

    private void infos() {
        this.setStepTitle(" les informations g\u00e9n\u00e9rales.");
        this.addHtml("Cet outil va vous permettre de supprimer une ou plusieurs dates de permanences, m\u00eame si des adh\u00e9rents sont d\u00e9j\u00e0 inscrits");
    }

    private void saisieDate() {
        this.setStepTitle("les dates \u00e0 supprimer");
        this.addHtml("Toutes les dates de permanences comprises entre ces deux dates seront supprim\u00e9es");
        NotNullValidator notNull = new NotNullValidator();
        this.addDateField("Date de la premi\u00e8re permanence \u00e0 supprimer", "dateDebut", notNull);
        this.addDateField("Date de la derni\u00e8re permanence \u00e0 supprimer", "dateFin", notNull);
    }

    private String checkDates() {
        if (this.dto.dateDebut.after(this.dto.dateFin)) {
            return "La date de d\u00e9but doit \u00eatre avant la date de fin";
        }
        return null;
    }

    private void confirmation() {
        String info = new PeriodePermanenceUpdateService().getDeleteDateInfo(this.dto);
        this.setStepTitle("confirmation avant suppression");
        this.addHtml("Vous allez apporter les modifications suivantes sur cette p\u00e9riode de permanence:");
        this.addHtml(info);
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() {
        new PeriodePermanenceUpdateService().performDeleteDatePermanence(this.dto);
    }
}

