/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.periode.update;

import fr.amapj.model.models.permanence.periode.NaturePeriodePermanence;
import fr.amapj.model.models.permanence.periode.PeriodePermanence;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.update.PeriodePermanenceUpdateService;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.engine.popup.formpopup.validator.StringLengthValidator;
import fr.amapj.view.engine.popup.formpopup.validator.UniqueInDatabaseValidator;

public class PopupModifEnteteForPeriodePermanence
extends WizardFormPopup {
    protected PeriodePermanenceDTO dto;

    public PopupModifEnteteForPeriodePermanence(Long id) {
        this.popupTitle = "Modification d'une p\u00e9riode de permanence";
        this.setWidth(80);
        this.dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(id);
        this.setModel(this.dto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.drawEntete());
        this.add(() -> this.drawFinInscription());
    }

    private void drawEntete() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales de cette p\u00e9riode de permanence");
        StringLengthValidator len_1_100 = new StringLengthValidator(1, 100);
        StringLengthValidator len_1_255 = new StringLengthValidator(1, 255);
        UniqueInDatabaseValidator uniq = new UniqueInDatabaseValidator(PeriodePermanence.class, "nom", this.dto.id);
        this.addTextField("Nom de la p\u00e9riode de permanence", "nom", len_1_100, uniq);
        this.addTextField("Description de la p\u00e9riode", "description", len_1_255);
    }

    private void drawFinInscription() {
        if (this.dto.nature == NaturePeriodePermanence.INSCRIPTION_LIBRE_FLOTTANT) {
            this.dto.dateFinInscription = null;
            this.setStepTitle("P\u00e9riode de permanence sans date limite d'inscription - D\u00e9lai pour modification des affectations");
            this.addIntegerField("D\u00e9lai en jour pour modification de son affectation avant permanence", "flottantDelai", new IValidator[0]);
        } else if (this.dto.nature == NaturePeriodePermanence.INSCRIPTION_LIBRE_AVEC_DATE_LIMITE) {
            this.setStepTitle("la date de fin des inscriptions");
            NotNullValidator notNull = new NotNullValidator();
            this.addDateField("Date de fin des inscriptions", "dateFinInscription", notNull);
        }
    }

    @Override
    protected void performSauvegarder() {
        new PeriodePermanenceUpdateService().updateEntete(this.dto);
    }
}

