/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.producteur;

import com.vaadin.data.Property;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import fr.amapj.model.models.fichierbase.EtatProducteur;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.service.services.access.AccessManagementService;
import fr.amapj.service.services.producteur.ProducteurService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.searcher.Searcher;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.searcher.SearcherList;
import java.io.Serializable;
import java.text.Collator;
import java.util.List;

public class ProducteurSelectorPart {
    private Searcher producteurBox;
    private Long idProducteur;
    private Button reinitButton;
    private List<Producteur> allowedProducteurs;
    private PopupListener listener;
    private boolean isCompactMode;

    public ProducteurSelectorPart(PopupListener listener, boolean actifOnly, boolean filterByUserRole) {
        this.listener = listener;
        if (filterByUserRole) {
            this.allowedProducteurs = new AccessManagementService().getAccessLivraisonProducteur(SessionManager.getUserRoles(), SessionManager.getUserId(), actifOnly);
        } else {
            this.allowedProducteurs = new ProducteurService().getAll(EtatProducteur.ACTIF);
            if (!actifOnly) {
                this.allowedProducteurs.addAll(new ProducteurService().getAll(EtatProducteur.ARCHIVE));
            }
            this.allowedProducteurs.sort((p1, p2) -> Collator.getInstance().compare(p1.nom, p2.nom));
        }
        this.isCompactMode = BaseUiTools.isCompactMode();
    }

    public HorizontalLayout getChoixProducteurComponent() {
        HorizontalLayout toolbar1 = new HorizontalLayout();
        toolbar1.addStyleName("producteur-selectorpart");
        if (this.allowedProducteurs.size() > 1) {
            this.constructMultipleProducteur(toolbar1);
        } else {
            this.constructOneProducteur(toolbar1);
        }
        toolbar1.setSpacing(true);
        toolbar1.setWidth("100%");
        return toolbar1;
    }

    private void constructOneProducteur(HorizontalLayout toolbar1) {
        Producteur p = this.allowedProducteurs.get(0);
        this.idProducteur = p.getId();
        String content = this.isCompactMode ? p.nom : "Producteur : " + p.nom;
        Label pLabel = BaseUiTools.addStdLabel((Layout)toolbar1, content, "unproducteur");
        pLabel.setSizeUndefined();
        toolbar1.setComponentAlignment((Component)pLabel, Alignment.MIDDLE_CENTER);
    }

    private void constructMultipleProducteur(HorizontalLayout toolbar1) {
        if (!this.isCompactMode) {
            Label pLabel = new Label("Producteur");
            pLabel.addStyleName("xproducteurs");
            pLabel.setSizeUndefined();
            toolbar1.addComponent((Component)pLabel);
        }
        this.producteurBox = new Searcher(SearcherList.PRODUCTEUR, null, this.allowedProducteurs);
        this.producteurBox.setImmediate(true);
        this.producteurBox.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.handleProducteurChange());
        this.reinitButton = new Button("Changer de producteur");
        this.reinitButton.addClickListener((Button.ClickListener & Serializable)e -> this.handleReinit());
        toolbar1.addComponent((Component)this.producteurBox);
        toolbar1.addComponent((Component)this.reinitButton);
        toolbar1.setExpandRatio((Component)this.reinitButton, 1.0f);
        toolbar1.setComponentAlignment((Component)this.reinitButton, Alignment.TOP_RIGHT);
    }

    private void handleProducteurChange() {
        this.idProducteur = (Long)this.producteurBox.getConvertedValue();
        if (this.idProducteur != null) {
            this.producteurBox.setEnabled(false);
        }
        this.listener.onPopupClose();
    }

    protected void handleReinit() {
        this.producteurBox.setValue(null);
        this.producteurBox.setEnabled(true);
        this.idProducteur = null;
        this.listener.onPopupClose();
    }

    public Long getProducteurId() {
        return this.idProducteur;
    }
}

