/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.producteur.basicform;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.TextArea;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.ProducteurStockGestion;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.param.EtatModule;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.producteur.ProdUtilisateurDTO;
import fr.amapj.service.services.producteur.ProducteurDTO;
import fr.amapj.service.services.producteur.ProducteurService;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.fieldlink.ClassicFieldLink;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionNoDuplicates;
import fr.amapj.view.engine.popup.formpopup.validator.ColumnNotNull;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.IntegerRangeValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.engine.popup.formpopup.validator.UniqueInDatabaseValidator;
import fr.amapj.view.views.searcher.SearcherList;
import java.util.List;

public class ProducteurEditorPart
extends WizardFormPopup {
    private ProducteurDTO producteurDTO;
    private boolean create;

    public ProducteurEditorPart(boolean create, Long idProducteur) {
        this.create = create;
        this.setWidth(80);
        this.setHeight("90%");
        if (create) {
            this.popupTitle = "Cr\u00e9ation d'un producteur";
            this.producteurDTO = new ProducteurDTO();
            this.producteurDTO.feuilleDistributionGrille = ChoixOuiNon.OUI;
            this.producteurDTO.feuilleDistributionListe = ChoixOuiNon.NON;
            this.producteurDTO.feuilleDistributionEtiquette = ChoixOuiNon.NON;
            this.producteurDTO.delaiModifContrat = 3;
            this.producteurDTO.gestionStock = ProducteurStockGestion.NON;
        } else {
            this.popupTitle = "Modification d'un producteur";
            this.producteurDTO = new ProducteurService().loadProducteur(idProducteur);
        }
        this.setModel(this.producteurDTO);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldGeneral());
        this.add(() -> this.addFieldDocuments(), () -> this.checkDocuments());
        this.add(() -> this.addFieldUtilisateur(), () -> this.checkFieldUtilisateurs());
        this.add(() -> this.addFieldReferents(), () -> this.checkFieldReferents());
        this.add(() -> this.addDivers());
    }

    private void addFieldGeneral() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales du producteur");
        UniqueInDatabaseValidator uniq = new UniqueInDatabaseValidator(Producteur.class, "nom", this.producteurDTO.id);
        NotNullValidator notNull = new NotNullValidator();
        this.addTextField("Nom", "nom", uniq, notNull);
        TextArea f = this.addTextAeraField("Description", "description");
        f.setMaxLength(20480);
        f.setHeight(5.0f, Sizeable.Unit.CM);
        if (new ParametresService().getParametres().etatGestionStock == EtatModule.ACTIF) {
            this.addComboEnumField("Activer la gestion des limites en quantit\u00e9 pour ce producteur", "gestionStock", new NotNullValidator());
        }
    }

    private void addFieldDocuments() {
        this.setStepTitle("les documents de ce producteur");
        this.addHtml("<b>La feuille de distribution producteur</b>");
        this.addComboEnumField("La feuille de distribution contient un onglet avec les produits \u00e0 livrer en tableau", "feuilleDistributionGrille", new NotNullValidator());
        this.addComboEnumField("La feuille de distribution contient un onglet avec les produits \u00e0 livrer en liste", "feuilleDistributionListe", new NotNullValidator());
        ClassicFieldLink fieldLink = new ClassicFieldLink();
        fieldLink.box = this.addComboEnumField("La feuille de distribution contient un onglet avec les \u00e9tiquettes des produits ", "feuilleDistributionEtiquette", new NotNullValidator());
        fieldLink.searcher = this.addSearcher("Type des \u00e9tiquettes", "idEtiquette", SearcherList.ETIQUETTE, null, fieldLink.getValidator());
        fieldLink.doLink();
        this.addHtml("<b>Le contrat d'engagement</b>");
        this.addTextField("Identification du producteur sur le contrat d'engagement", "libContrat", new IValidator[0]);
        this.addHtml("<b>L'envoi automatique des feuilles de distribution au producteur</b>");
        this.addIntegerField("D\u00e9lai en jours entre l'envoi de la feuille de distribution par mail et la livraison", "delaiModifContrat", new IntegerRangeValidator(0, null));
        String str = "Exemple :<br>Si les livraisons ont lieu le jeudi et si vous mettez 3 dans le champ pr\u00e9c\u00e9dent<br>alors le producteur recevra le mail avec la feuille de distribution le lundi \u00e0 2h00 du matin<br>";
        this.addHtml(str);
    }

    private String checkDocuments() {
        if (this.producteurDTO.feuilleDistributionEtiquette == ChoixOuiNon.NON && this.producteurDTO.feuilleDistributionGrille == ChoixOuiNon.NON && this.producteurDTO.feuilleDistributionListe == ChoixOuiNon.NON) {
            return "La feuille de distribution ne peut pas \u00eatre vide. Il faut mettre au moins un OUI entre \"La feuille de distribution contient un onglet avec les produits \u00e0 livrer en tableau\", \"La feuille de distribution contient un onglet avec les produits \u00e0 livrer en liste\" , et \"La feuille de distribution contient un onglet avec les \u00e9tiquettes des produits \".";
        }
        return null;
    }

    private void addFieldUtilisateur() {
        this.setStepTitle("les noms des producteurs");
        this.addHtml("Vous pouvez laisser cette liste vide dans un premier temps");
        CollectionNoDuplicates<ProdUtilisateurDTO> noDuplicates = new CollectionNoDuplicates<ProdUtilisateurDTO>(e -> e.idUtilisateur, e -> new UtilisateurService().prettyString(e.idUtilisateur));
        this.addCollectionEditorField("Liste des producteurs", "utilisateurs", ProdUtilisateurDTO.class, noDuplicates);
        this.addColumnSearcher("idUtilisateur", "Nom du producteur", FieldType.SEARCHER, null, SearcherList.UTILISATEUR_ACTIF, null, new ColumnNotNull<ProdUtilisateurDTO>(e -> e.idUtilisateur));
        this.addColumn("etatNotification", "Envoi feuille de livraison", FieldType.CHECK_BOX, true, new IValidator[0]);
    }

    private String checkFieldUtilisateurs() {
        List<ProdUtilisateurDTO> us = this.producteurDTO.utilisateurs;
        return this.checkHasEmail(us);
    }

    private String checkHasEmail(List<ProdUtilisateurDTO> us) {
        for (ProdUtilisateurDTO lig : us) {
            if (lig.idUtilisateur == null || !lig.etatNotification) continue;
            UtilisateurDTO dto = new UtilisateurService().loadUtilisateurDto(lig.idUtilisateur);
            if (UtilisateurUtil.canSendMailTo(dto.email)) continue;
            return "L'utilisateur " + dto.nom + " " + dto.prenom + " n'a pas d'adresse e mail. Vous ne pouvez donc pas le notifier.";
        }
        return null;
    }

    private void addFieldReferents() {
        this.setStepTitle("les noms des r\u00e9f\u00e9rents");
        this.addHtml("Vous pouvez laisser cette liste vide dans un premier temps");
        CollectionNoDuplicates<ProdUtilisateurDTO> noDuplicates = new CollectionNoDuplicates<ProdUtilisateurDTO>(e -> e.idUtilisateur, e -> new UtilisateurService().prettyString(e.idUtilisateur));
        this.addCollectionEditorField("Liste des r\u00e9f\u00e9rents", "referents", ProdUtilisateurDTO.class, noDuplicates);
        this.addColumnSearcher("idUtilisateur", "Nom des r\u00e9f\u00e9rents", FieldType.SEARCHER, null, SearcherList.UTILISATEUR_ACTIF, null, new ColumnNotNull<ProdUtilisateurDTO>(e -> e.idUtilisateur));
        this.addColumn("etatNotification", "Envoi feuille de livraison", FieldType.CHECK_BOX, false, new IValidator[0]);
    }

    private String checkFieldReferents() {
        List<ProdUtilisateurDTO> us = this.producteurDTO.referents;
        return this.checkHasEmail(us);
    }

    private void addDivers() {
        this.setStepTitle("Divers");
        this.addHtml("Gestion des notifications par e mail quand un adh\u00e9rent s'inscrit en tant que nouvel arrivant / retardataire");
        this.addComboEnumField("Mode de notification nouvel arrivant / retardataire", "notificationRetardataire", new NotNullValidator());
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        new ProducteurService().update(this.producteurDTO, this.create);
    }
}

