/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.producteur.basicform;

import fr.amapj.model.models.fichierbase.EtatProducteur;
import fr.amapj.service.services.producteur.ProducteurDTO;
import fr.amapj.service.services.producteur.ProducteurService;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.views.producteur.basicform.PopupProducteurArchiver;
import fr.amapj.view.views.producteur.basicform.ProducteurEditorPart;
import fr.amapj.view.views.producteur.basicform.ProducteurVoirPart;
import java.util.List;

public class ProducteurListPart
extends StandardListPart<ProducteurDTO> {
    public ProducteurListPart() {
        super(ProducteurDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des producteurs";
    }

    @Override
    protected void drawButton() {
        this.addButton("Cr\u00e9er un nouveau producteur", ButtonType.ALWAYS, e -> new ProducteurEditorPart(true, null));
        this.addButton("Modifier", ButtonType.EDIT_MODE, e -> new ProducteurEditorPart(false, e.id));
        this.addButton("Voir", ButtonType.EDIT_MODE, e -> new ProducteurVoirPart((ProducteurDTO)e));
        this.addButton("Supprimer", ButtonType.EDIT_MODE, e -> this.handleSupprimer());
        this.addButton("Archiver", ButtonType.EDIT_MODE, e -> new PopupProducteurArchiver((ProducteurDTO)e));
        this.addSearchField("Rechercher par nom");
    }

    @Override
    protected void drawTable() {
        this.addColumn("nom", "Nom");
        this.addColumn("utilisateurInfo", "Producteurs");
        this.addColumn("referentInfo", "Referents");
        this.addColumn("nbModeleContratActif", "Nb contrats").center();
        this.addColumnDate("dateDerniereLivraison", "Derni\u00e8re liv");
        this.addColumnDate("dateCreation", "Date cr\u00e9ation");
    }

    @Override
    protected List<ProducteurDTO> getLines() {
        return new ProducteurService().getAllProducteurs(EtatProducteur.ACTIF);
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nom"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom"};
    }

    private SuppressionPopup handleSupprimer() {
        ProducteurDTO dto = (ProducteurDTO)this.getSelectedLine();
        String text = "Etes vous s\u00fbr de vouloir supprimer le producteur " + dto.nom + " ?";
        return new SuppressionPopup(text, dto.id, e -> new ProducteurService().delete((Long)e));
    }
}

