/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.producteur.contrats;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineDTO;
import fr.amapj.service.services.docengagement.signonline.core.CoreDocEngagementSignOnLineService;
import fr.amapj.service.services.edgenerator.zip.ZGAllDocEngagementSigne;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import java.io.Serializable;
import java.util.List;

public class PopupSignatureProducteurAll
extends CorePopup {
    private CheckBox cb;
    private List<DocEngagementSignOnLineDTO> dtos;
    private Long userId;
    private VerticalLayout contentLayout;

    public PopupSignatureProducteurAll(ModeleContratSummaryDTO mc, List<DocEngagementSignOnLineDTO> dtos, Long userId) {
        if (dtos.size() < 2) {
            throw new AmapjRuntimeException();
        }
        this.userId = userId;
        this.dtos = dtos;
        this.popupTitle = "Signature des documents pour le contrat " + mc.nom;
        this.setWidth(50);
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.contentLayout = contentLayout;
        this.addLabel("Vous avez " + this.dtos.size() + " documents \u00e0 signer.");
        this.addLabel("");
        this.addLabel("Merci de cliquer sur le lien ci dessous pour t\u00e9l\u00e9charger les " + this.dtos.size() + " documents \u00e0 signer, puis de cliquer ensuite sur la case \u00e0 cocher \"J'ai lu et je signe ces " + this.dtos.size() + " documents\"");
        this.addLabel("");
        ZGAllDocEngagementSigne zg = new ZGAllDocEngagementSigne(this.dtos);
        zg.setNameToDisplaySuffix(" \u00e0 signer");
        contentLayout.addComponent((Component)LinkCreator.createLink(zg));
        this.addLabel("");
        this.cb = new CheckBox("J'ai lu et je signe ces " + this.dtos.size() + " documents");
        this.cb.setValue((Object)false);
        this.cb.addStyleName("signature");
        contentLayout.addComponent((Component)this.cb);
        this.addLabel("");
    }

    private void addLabel(String str) {
        Label l = new Label(str);
        this.contentLayout.addComponent((Component)l);
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.addButton("Annuler", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
        this.addDefaultButton("Sauvegarder", (Button.ClickListener & Serializable)e -> this.handleSauvegarder());
    }

    protected void handleAnnuler() {
        this.close();
    }

    public void handleSauvegarder() {
        if (!((Boolean)this.cb.getValue()).booleanValue()) {
            new MessagePopup("Validation demand\u00e9e", ContentMode.HTML, CorePopup.ColorStyle.RED, "Vous devez signer ces documents en cliquant sur la case \u00e0 cocher \"J'ai lu et je signe tous ces documents\"").open();
            return;
        }
        this.dtos.forEach(e -> new CoreDocEngagementSignOnLineService().saveDocEngagementSigneByProducteur(e.idContrat, this.userId));
        this.close();
    }
}

