/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.producteur.contrats;

import com.vaadin.ui.Component;
import fr.amapj.model.models.contrat.modele.GestionDocEngagement;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.param.EtatModule;
import fr.amapj.model.models.param.paramecran.producteur.PEContratProducteur;
import fr.amapj.service.services.access.AccessManagementService;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineDTO;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineService;
import fr.amapj.service.services.edgenerator.excel.EGCollecteCheque;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur.EGFeuilleDistributionProducteur;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur.EGSyntheseContrat;
import fr.amapj.service.services.edgenerator.excel.producteur.EGPaiementProducteur;
import fr.amapj.service.services.edgenerator.zip.ZGAllDocEngagementModeleContrat;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.producteur.ProducteurService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.excelgenerator.TelechargerPopup;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.popup.swicthpopup.SwitchPopup;
import fr.amapj.view.views.producteur.ProducteurSelectorPart;
import fr.amapj.view.views.producteur.contrats.PopupSignatureProducteurAll;
import fr.amapj.view.views.producteur.contrats.PopupSignatureProducteurOneByOne;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.stock.GestionContratStockPart;
import java.util.List;

public class ProducteurContratListPart
extends StandardListPart<ModeleContratSummaryDTO> {
    private ProducteurSelectorPart producteurSelector;
    private PEContratProducteur pe = (PEContratProducteur)new ParametresService().loadParamEcran(MenuList.CONTRATS_PRODUCTEUR);

    public ProducteurContratListPart() {
        super(ModeleContratSummaryDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des contrats d'un producteur";
    }

    @Override
    protected void addSelectorComponent() {
        this.producteurSelector = new ProducteurSelectorPart(this, true, true);
        this.addComponent((Component)this.producteurSelector.getChoixProducteurComponent());
    }

    @Override
    protected void drawButton() {
        this.addButtonAction("Tester", ButtonType.EDIT_MODE, () -> this.handleTester());
        if (new ParametresService().getParametres().etatGestionStock == EtatModule.ACTIF && this.pe.modifierQteStock == ChoixOuiNon.OUI) {
            this.addButton("Stock", ButtonType.EDIT_MODE, e -> GestionContratStockPart.handleStock(e.id));
        }
        this.addButton("T\u00e9l\u00e9charger ...", ButtonType.EDIT_MODE, e -> this.handleTelecharger());
        this.addButton("Signer les documents ...", ButtonType.EDIT_MODE, e -> this.handleSigner((ModeleContratSummaryDTO)e));
        this.addSearchField("Rechercher par nom");
    }

    private CorePopup handleSigner(ModeleContratSummaryDTO mc) {
        if (mc.gestionDocEngagement != GestionDocEngagement.SIGNATURE_EN_LIGNE) {
            return new MessagePopup("Signature des documents", CorePopup.ColorStyle.GREEN, "Ce contrat ne g\u00e8re pas la signature en ligne.");
        }
        if (new DocEngagementSignOnLineService().producteurIsNotAllowedToSignNow(mc.id)) {
            return new MessagePopup("Signature des documents", CorePopup.ColorStyle.GREEN, "Les amapiens peuvent encore s'inscrire sur ce contrat. Vous pourrez signer les contrats apr\u00e8s la date de fin des inscriptions");
        }
        Long userId = SessionManager.getUserId();
        if (!new AccessManagementService().isAllowToSign(userId, mc.producteurId)) {
            return new MessagePopup("Signature des documents", CorePopup.ColorStyle.RED, "Vous n'\u00e9tes pas autoris\u00e9 \u00e0 signer ces documents");
        }
        List<DocEngagementSignOnLineDTO> dtos = new DocEngagementSignOnLineService().getAllDocumentsASignerByProducteur(mc.id);
        if (dtos.size() == 0) {
            return new MessagePopup("Signature des documents", CorePopup.ColorStyle.GREEN, "Il n'y a pas de documents \u00e0 signer pour le contrat " + mc.nom);
        }
        if (dtos.size() == 1) {
            return new PopupSignatureProducteurOneByOne(mc, dtos, userId);
        }
        SwitchPopup popup = new SwitchPopup("Signature des documents", 60);
        popup.setLine1("Vous avez " + dtos.size() + " documents \u00e0 signer pour le contrat " + mc.nom + ". Comment voulez vous les signer?");
        popup.addLine("Signer tous les documents en une seule fois", () -> new PopupSignatureProducteurAll(mc, dtos, userId));
        popup.addLine("Signer les documents un par un ", () -> new PopupSignatureProducteurOneByOne(mc, dtos, userId));
        return popup;
    }

    @Override
    protected void drawTable() {
        this.addColumn("etat", "Etat");
        this.addColumn("nom", "Nom");
        this.addColumnDate("finInscription", "Fin inscription");
        this.addColumnDate("dateDebut", "Premi\u00e8re livraison");
        this.addColumnDate("dateFin", "Derni\u00e8re livraison");
        this.addColumn("nbLivraison", "Nb de livraisons");
        this.addColumn("nbProduit", "Nb de produits").center();
        this.addColumn("nbInscrits", "Nb d'inscrits").center();
        this.addColumn("nbContratASignerProducteur", "Nb documents \u00e0 signer").center();
    }

    @Override
    protected List<ModeleContratSummaryDTO> getLines() {
        Long idProducteur = this.producteurSelector.getProducteurId();
        if (idProducteur == null) {
            return null;
        }
        return new ProducteurService().getModeleContratInfo(idProducteur);
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"etat", "dateDebut"};
    }

    @Override
    protected boolean[] getSortAsc() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        return blArray;
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom"};
    }

    private void handleTester() {
        ModeleContratSummaryDTO mcDto = (ModeleContratSummaryDTO)this.getSelectedLine();
        SaisieContrat.saisieContrat(mcDto.id, null, null, "Mode Test", SaisieContrat.ModeSaisie.FOR_TEST, this);
    }

    private CorePopup handleTelecharger() {
        ModeleContratSummaryDTO mcDto = (ModeleContratSummaryDTO)this.getSelectedLine();
        TelechargerPopup popup = new TelechargerPopup("Producteur");
        popup.addGenerator(new EGFeuilleDistributionProducteur(mcDto.id));
        popup.addGenerator(new EGSyntheseContrat(mcDto.id));
        popup.addLabel("");
        popup.addGenerator(new EGPaiementProducteur(mcDto.id));
        if (this.pe.telechargerFeuilleCollecteCheque == ChoixOuiNon.OUI) {
            popup.addGenerator(new EGCollecteCheque(mcDto.id));
        }
        popup.addLabel("");
        if (mcDto.gestionDocEngagement == GestionDocEngagement.SIGNATURE_EN_LIGNE) {
            popup.addGenerator(new ZGAllDocEngagementModeleContrat(mcDto.id));
        }
        return popup;
    }
}

