/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.producteur.livraison;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Link;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.GenericUtils;
import fr.amapj.common.periode.PeriodeUtils;
import fr.amapj.model.models.param.paramecran.producteur.PELivraisonProducteur;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur.EGFeuilleDistributionProducteur;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.meslivraisons.JourLivraisonsDTO;
import fr.amapj.service.services.meslivraisons.MesLivraisonsDTO;
import fr.amapj.service.services.meslivraisons.MesLivraisonsService;
import fr.amapj.service.services.meslivraisons.ProducteurLivraisonsDTO;
import fr.amapj.service.services.meslivraisons.QteProdDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.template.FrontOfficeView;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.common.gapviewer.AbstractGapViewer;
import fr.amapj.view.views.common.gapviewer.GapViewerUtil;
import fr.amapj.view.views.producteur.ProducteurSelectorPart;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ProducteurLivraisonsView
extends FrontOfficeView
implements PopupListener {
    SimpleDateFormat df1 = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
    private ProducteurSelectorPart producteurSelector;
    private VerticalLayout central;
    private static String LABEL_DATEJOURLIV = "datejourliv";
    private static String LABEL_QTEPRODUIT = "qteproduit";
    private static String PANEL_UNJOUR = "unjour";
    private AbstractGapViewer gapViewer;

    @Override
    public String getMainStyleName() {
        return "producteur-livraison";
    }

    @Override
    public void enter() {
        PELivraisonProducteur pe = (PELivraisonProducteur)new ParametresService().loadParamEcran(MenuList.LIVRAISONS_PRODUCTEUR);
        this.producteurSelector = new ProducteurSelectorPart(this, true, pe.accesEcran == PELivraisonProducteur.PELivraisonProducteurAccess.PRODUCTEUR);
        this.addComponent((Component)this.producteurSelector.getChoixProducteurComponent());
        this.gapViewer = GapViewerUtil.createGapWiever(pe.modeAffichage, this, (date, next) -> this.handleNextDate(date, next));
        this.addComponent((Component)this.gapViewer.getComponent());
        this.central = new VerticalLayout();
        this.addComponent((Component)this.central);
        this.onPopupClose();
    }

    @Override
    public void onPopupClose() {
        this.central.removeAllComponents();
        Long idProducteur = this.producteurSelector.getProducteurId();
        if (idProducteur == null) {
            return;
        }
        MesLivraisonsDTO res = new MesLivraisonsService().getLivraisonProducteur(this.gapViewer.getDateDebut(), this.gapViewer.getDateFin(), idProducteur);
        for (JourLivraisonsDTO jour : res.jours) {
            VerticalLayout vl = BaseUiTools.addPanel((Layout)this.central, PANEL_UNJOUR);
            String dateMessage = this.df1.format(jour.date);
            BaseUiTools.addStdLabel((Layout)vl, dateMessage, LABEL_DATEJOURLIV);
            for (ProducteurLivraisonsDTO producteurLiv : jour.producteurs) {
                BaseUiTools.addBandeau((Layout)vl, producteurLiv.modeleContrat, "nomcontrat");
                String msg = "<b>Quantit\u00e9s totales \u00e0 livrer :</b><ul>";
                for (QteProdDTO cell : producteurLiv.produits) {
                    msg = String.valueOf(msg) + "<li>" + cell.qte + " " + cell.nomProduit + " , " + cell.conditionnementProduit + "</li>";
                }
                msg = String.valueOf(msg) + "</ul>";
                BaseUiTools.addHtmlLabel((Layout)vl, msg, LABEL_QTEPRODUIT);
                Button b = new Button("Voir le d\u00e9tail par amapien");
                b.setIcon((Resource)FontAwesome.CHEVRON_DOWN);
                vl.addComponent((Component)b);
                Label detail = BaseUiTools.addHtmlLabel((Layout)vl, "", LABEL_QTEPRODUIT);
                b.addStyleName("icon-align-right");
                b.addStyleName("large");
                b.addClickListener((Button.ClickListener & Serializable)e -> this.buttonClick(detail, b, producteurLivraisonsDTO.idModeleContratDate));
                b.setData((Object)new Boolean(false));
                Link extractFile = LinkCreator.createLink(new EGFeuilleDistributionProducteur(producteurLiv.idModeleContrat, producteurLiv.idModeleContratDate));
                vl.addComponent((Component)extractFile);
            }
        }
        if (res.jours.size() == 0) {
            String dateMessage = "Pas de livraison pour " + PeriodeUtils.getDescriptionPeriode(this.gapViewer.getTypPeriode(), this.gapViewer.getDateDebut(), this.gapViewer.getDateFin());
            BaseUiTools.addStdLabel((Layout)this.central, dateMessage, LABEL_DATEJOURLIV);
        }
        this.endOfRefresh();
    }

    public void buttonClick(Label detail, Button b, Long idModeleContratDate) {
        boolean status = (Boolean)b.getData();
        status = !status;
        b.setData((Object)status);
        if (status) {
            b.setCaption("Masquer le d\u00e9tail par amapien");
            b.setIcon((Resource)FontAwesome.CHEVRON_UP);
            String content = new GestionContratService().getDetailContrat(idModeleContratDate);
            detail.setValue("<br/>" + content);
        } else {
            b.setCaption("Voir le d\u00e9tail par amapien");
            b.setIcon((Resource)FontAwesome.CHEVRON_DOWN);
            detail.setValue("");
        }
    }

    private GenericUtils.Ret<Date> handleNextDate(Date date, boolean next) {
        Long idProd = this.producteurSelector.getProducteurId();
        if (idProd == null) {
            return GenericUtils.Ret.error("Merci de saisir le producteur");
        }
        Date d = new MesLivraisonsService().provideNextDateProducteur(date, next, idProd);
        if (d == null) {
            return GenericUtils.Ret.error(next ? "Il n'y a pas de date de livraison suivante" : "Il n'y a pas de date de livraison pr\u00e9cedente");
        }
        return GenericUtils.Ret.ok(d);
    }
}

