/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.receptioncheque;

import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import fr.amapj.service.services.gestioncontratsigne.ContratSigneDTO;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.swicthpopup.SwitchPopup;
import fr.amapj.view.views.common.contratselector.ContratSelectorPart;
import fr.amapj.view.views.common.contrattelecharger.TelechargerContrat;
import fr.amapj.view.views.receptioncheque.PopupChercherChequeARendre;
import fr.amapj.view.views.receptioncheque.PopupSaisieAvoir;
import fr.amapj.view.views.receptioncheque.ReceptionChequeEditorPart;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import java.util.List;

public class ReceptionChequeListPart
extends StandardListPart<ContratSigneDTO> {
    private ContratSelectorPart contratSelectorPart;

    public ReceptionChequeListPart() {
        super(ContratSigneDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "R\u00e9ception des ch\u00e8ques";
    }

    @Override
    protected void drawButton() {
        this.addButtonAction("Visualiser", ButtonType.EDIT_MODE, () -> this.handleVoir());
        this.addButton("R\u00e9ceptionner les ch\u00e8ques", ButtonType.EDIT_MODE, e -> new ReceptionChequeEditorPart(e.idContrat, e.nomUtilisateur, e.prenomUtilisateur));
        this.addButtonAction("Modifier les ch\u00e8ques", ButtonType.EDIT_MODE, () -> this.handleModifierCheque());
        this.addButton("Saisir un avoir", ButtonType.EDIT_MODE, e -> new PopupSaisieAvoir((ContratSigneDTO)e));
        this.addButton("R\u00e9ception en masse", ButtonType.ALWAYS, e -> new ReceptionChequeEditorPart(this.contratSelectorPart.getModeleContratId()));
        this.addButton("Autre...", ButtonType.ALWAYS, e -> this.handleMore());
        this.addButton("T\u00e9l\u00e9charger ...", ButtonType.ALWAYS, e -> this.handleTelecharger());
        this.addSearchField("Rechercher par nom ou pr\u00e9nom");
    }

    @Override
    protected void addSelectorComponent() {
        this.contratSelectorPart = new ContratSelectorPart(this, true);
        HorizontalLayout toolbar1 = this.contratSelectorPart.getChoixContratComponent();
        this.addComponent((Component)toolbar1);
        this.contratSelectorPart.fillAutomaticValues();
    }

    @Override
    protected void drawTable() {
        this.addColumn("nomUtilisateur", "Nom");
        this.addColumn("prenomUtilisateur", "Pr\u00e9nom");
        this.addColumnCurrency("mntCommande", "Command\u00e9(en \u20ac)").right();
        this.addColumn("nbChequePromis", "Ch\u00e8ques \u00e0 fournir \u00e0 l'AMAP").center();
        this.addColumn("nbChequeRecus", "Ch\u00e8ques \u00e0 l'AMAP").center();
        this.addColumn("nbChequeRemis", "Ch\u00e8ques chez le producteur").center();
        this.addColumnCurrency("mntSolde", "Solde final(en \u20ac)").right();
        this.addColumnCurrency("mntAvoirInitial", "Avoir initial(en \u20ac)").right();
    }

    @Override
    protected List<ContratSigneDTO> getLines() {
        Long idModeleContrat = this.contratSelectorPart.getModeleContratId();
        if (idModeleContrat == null) {
            return null;
        }
        return new GestionContratSigneService().getAllContratSigne(idModeleContrat);
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nomUtilisateur", "prenomUtilisateur"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nomUtilisateur", "prenomUtilisateur"};
    }

    private CorePopup handleMore() {
        Long idModeleContrat = this.contratSelectorPart.getModeleContratId();
        SwitchPopup popup = new SwitchPopup("Autres actions sur les paiements", 50);
        popup.addLine("Chercher les ch\u00e8ques \u00e0 rendre aux amapiens", () -> new PopupChercherChequeARendre(idModeleContrat));
        return popup;
    }

    private CorePopup handleTelecharger() {
        Long idModeleContrat = this.contratSelectorPart.getModeleContratId();
        ContratSigneDTO contratSigneDTO = (ContratSigneDTO)this.getSelectedLine();
        Long idContrat = null;
        if (contratSigneDTO != null) {
            idContrat = contratSigneDTO.idContrat;
        }
        return TelechargerContrat.displayPopupTelechargerContrat(idModeleContrat, idContrat);
    }

    private void handleModifierCheque() {
        ContratSigneDTO c = (ContratSigneDTO)this.getSelectedLine();
        String message = "Modification des ch\u00e8ques de " + c.prenomUtilisateur + " " + c.nomUtilisateur;
        SaisieContrat.saisieContrat(c.idModeleContrat, c.idContrat, c.idUtilisateur, message, SaisieContrat.ModeSaisie.CHEQUE_SEUL, this);
    }

    private void handleVoir() {
        ContratSigneDTO c = (ContratSigneDTO)this.getSelectedLine();
        String message = "Visualisation du contrat de " + c.prenomUtilisateur + " " + c.nomUtilisateur;
        SaisieContrat.saisieContrat(c.idModeleContrat, c.idContrat, c.idUtilisateur, message, SaisieContrat.ModeSaisie.READ_ONLY, this);
    }
}

