/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.step1qte.abo;

import fr.amapj.common.GenericUtils;
import fr.amapj.service.services.mescontrats.ContratColDTO;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.view.views.saisiecontrat.abo.ContratAbo;
import fr.amapj.view.views.saisiecontrat.abo.model.AboData;
import fr.amapj.view.views.saisiecontrat.abo.model.AboDataLig;
import fr.amapj.view.views.saisiecontrat.abo.model.AboDataManager;
import fr.amapj.view.views.saisiecontrat.abo.model.AboDataProd;
import java.util.Date;

public class ContratAboManager {
    public ContratAbo computeContratAboNewContrat(ContratDTO dto, Date startDate) {
        int[] qte = new int[dto.contratColumns.size()];
        for (ContratLigDTO lig : dto.contratLigs) {
            lig.status = startDate != null && lig.date.before(startDate) ? ContratLigDTO.AboLigStatus.FORCED_TO_0 : ContratLigDTO.AboLigStatus.NORMAL;
        }
        ContratAbo abo = new ContratAbo(dto, qte);
        return abo;
    }

    public GenericUtils.Ret<ContratAbo> computeContratAboExistingContrat(ContratDTO dto, String aboDataString) {
        if (aboDataString == null || aboDataString.length() == 0) {
            return GenericUtils.Ret.error("Pas de donn\u00e9es en base");
        }
        AboData aboData = AboDataManager.fromString(aboDataString);
        for (ContratLigDTO lig : dto.contratLigs) {
            AboDataLig aboDataLig = this.findAboDataLig(lig.date, aboData);
            if (aboDataLig != null) {
                lig.status = aboDataLig.status;
                lig.reportDateDestination = aboDataLig.reportDateDestination;
                continue;
            }
            lig.status = ContratLigDTO.AboLigStatus.NORMAL;
        }
        int[] qte = this.extractCondenseQte(dto, aboData);
        ContratAbo abo = new ContratAbo(dto, qte);
        String str = abo.checkValid();
        if (str != null) {
            return GenericUtils.Ret.error(str);
        }
        return GenericUtils.Ret.ok(abo);
    }

    private int[] extractCondenseQte(ContratDTO dto, AboData aboData) {
        int[] res = new int[dto.contratColumns.size()];
        int j = 0;
        while (j < dto.contratColumns.size()) {
            ContratColDTO col = dto.contratColumns.get(j);
            res[j] = this.findQte(col.modeleContratProduitId, aboData);
            ++j;
        }
        return res;
    }

    private int findQte(Long idProduit, AboData aboData) {
        for (AboDataProd prod : aboData.prods) {
            if (!idProduit.equals(prod.idProduit)) continue;
            return prod.qte;
        }
        return 0;
    }

    private AboDataLig findAboDataLig(Date date, AboData aboData) {
        for (AboDataLig aboDataLig : aboData.ligs) {
            if (!aboDataLig.date.equals(date)) continue;
            return aboDataLig;
        }
        return null;
    }

    public String computeJokerMessage(ContratDTO contratDTO, int used) {
        switch (contratDTO.typJoker) {
            case JOKER_ABSENCE: {
                return this.computeJokerMessageAbsenceMode(contratDTO, used);
            }
            case JOKER_REPORT: {
                return this.computeJokerMessageReportMode(contratDTO, used);
            }
        }
        return "";
    }

    private String computeJokerMessageAbsenceMode(ContratDTO contratDTO, int used) {
        StringBuilder sb = new StringBuilder();
        if (contratDTO.jokerNbMin == 0) {
            if (contratDTO.jokerNbMax == 1) {
                sb.append("Ce contrat autorise 1 joker maximum.");
            } else {
                sb.append("Ce contrat autorise " + contratDTO.jokerNbMax + " jokers maximum.");
            }
        } else if (contratDTO.jokerNbMin == contratDTO.jokerNbMax) {
            sb.append("Ce contrat impose " + contratDTO.jokerNbMin + " joker(s).");
        } else {
            sb.append("Ce contrat impose " + contratDTO.jokerNbMin + " joker(s) au minimum et autorise " + contratDTO.jokerNbMax + " joker(s) au maximum.");
        }
        if (used == 0) {
            sb.append("Vous avez utilis\u00e9 aucun joker.");
        } else if (used == 1) {
            sb.append("Vous avez utilis\u00e9 1 joker.");
        } else {
            sb.append("Vous avez utilis\u00e9 " + used + " jokers.");
        }
        return sb.toString();
    }

    private String computeJokerMessageReportMode(ContratDTO contratDTO, int used) {
        StringBuilder sb = new StringBuilder();
        if (contratDTO.jokerNbMax == 1) {
            sb.append("Ce contrat autorise 1 report (joker) maximum.");
        } else {
            sb.append("Ce contrat autorise " + contratDTO.jokerNbMax + " reports (jokers) maximum.");
        }
        if (used == 0) {
            sb.append("Vous avez utilis\u00e9 aucun report (joker).");
        } else if (used == 1) {
            sb.append("Vous avez utilis\u00e9 1 report (joker).");
        } else {
            sb.append("Vous avez utilis\u00e9 " + used + " reports (jokers).");
        }
        return sb.toString();
    }
}

