/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.step1qte.abo;

import fr.amapj.service.services.mescontrats.ContratColDTO;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.view.engine.grid.GridHeaderLine;
import fr.amapj.view.engine.grid.GridSizeCalculator;
import fr.amapj.view.engine.grid.integergrid.IntegerGridLine;
import fr.amapj.view.engine.grid.integergrid.PopupIntegerGrid;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import java.text.SimpleDateFormat;
import java.util.List;

public class PopupDetailDate
extends PopupIntegerGrid {
    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
    private ContratDTO contratDTO;

    public PopupDetailDate(ContratDTO contratDTO) {
        this.contratDTO = contratDTO;
        this.popupTitle = "D\u00e9tails des dates";
    }

    @Override
    public void loadParam() {
        this.param.readOnly = true;
        this.param.libButtonSave = "OK";
        this.param.nbLig = this.contratDTO.contratLigs.size();
        this.param.nbCol = this.contratDTO.contratColumns.size();
        this.param.cell = this.contratDTO.extractCells();
        List<ContratLigDTO> contratLigs = this.contratDTO.contratLigs;
        int i = 0;
        while (i < contratLigs.size()) {
            ContratLigDTO lig = contratLigs.get(i);
            Object s = null;
            if (lig.status == ContratLigDTO.AboLigStatus.FORCED_TO_0) {
                s = "------";
            }
            if (lig.status == ContratLigDTO.AboLigStatus.JOKER) {
                s = "JOKER";
            }
            if (lig.status == ContratLigDTO.AboLigStatus.REPORT) {
                s = "REPORT";
            }
            if (s != null) {
                int j = 0;
                while (j < this.param.nbCol) {
                    this.param.cell[i][j].isStaticText = true;
                    this.param.cell[i][j].staticText = s;
                    ++j;
                }
            }
            ++i;
        }
        this.param.largeurCol = 110;
        GridHeaderLine line1 = new GridHeaderLine();
        line1.addCell("Produit");
        for (ContratColDTO col : this.contratDTO.contratColumns) {
            line1.addCell(col.nomProduit);
        }
        GridSizeCalculator.autoSize(line1, this.param.largeurCol, "Arial", 16);
        GridHeaderLine line2 = new GridHeaderLine();
        line2.style = GridHeaderLine.GridHeaderLineStyle.PRIX;
        line2.addCell("prix unitaire");
        for (ContratColDTO col : this.contratDTO.contratColumns) {
            line2.addCell(new CurrencyTextFieldConverter().convertToString(col.prix));
        }
        GridHeaderLine line3 = new GridHeaderLine();
        line3.addCell("Dates");
        for (ContratColDTO col : this.contratDTO.contratColumns) {
            line3.addCell(col.condtionnementProduit);
        }
        GridSizeCalculator.autoSize(line3, this.param.largeurCol, "Arial", 16);
        this.param.headerLines.add(line1);
        this.param.headerLines.add(line2);
        this.param.headerLines.add(line3);
        this.param.leftPartLineLargeur = 110;
        this.param.leftPartLineStyle = "date-saisie";
        for (ContratLigDTO lig : this.contratDTO.contratLigs) {
            IntegerGridLine line = new IntegerGridLine();
            line.isVisible = true;
            line.leftPart = this.df.format(lig.date);
            this.param.lines.add(line);
        }
    }

    @Override
    public boolean performSauvegarder() {
        return false;
    }

    @Override
    public int getLineHeight(boolean readOnly) {
        return readOnly ? 26 : 32;
    }

    @Override
    public int getHeaderHeight() {
        return BaseUiTools.isCompactMode() ? 270 : 365;
    }
}

