/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.step1qte.std.grid;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.models.contrat.modele.AffichageMontant;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.service.services.mescontrats.ContratColDTO;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.view.engine.grid.GridHeaderLine;
import fr.amapj.view.engine.grid.GridSizeCalculator;
import fr.amapj.view.engine.grid.integergrid.IntegerGridLine;
import fr.amapj.view.engine.grid.integergrid.PopupIntegerGrid;
import fr.amapj.view.engine.grid.integergrid.lignecumul.LigneCumulParam;
import fr.amapj.view.engine.grid.integergrid.lignecumul.TypLigneCumul;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.saisiecontrat.step1qte.std.onedatetable.PopupSaisieQteTable;
import fr.amapj.view.views.saisiecontrat.step1qte.std.vueliste.PopupSaisieQteVueListe;
import fr.amapj.view.views.saisiecontrat.step1qte.utils.ProduitHelpSupplier;
import fr.amapj.view.views.saisiecontrat.step1qte.utils.checkonend.CheckOnEndSaisieQte;
import java.text.SimpleDateFormat;

public class PopupSaisieQteContrat
extends PopupIntegerGrid {
    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
    private ContratDTO contratDTO;
    private SaisieContrat.SaisieContratData data;

    public PopupSaisieQteContrat(SaisieContrat.SaisieContratData data) {
        this.data = data;
        this.contratDTO = data.contratDTO;
        this.popupTitle = "Mon contrat " + this.contratDTO.nom;
        this.param.readOnly = data.modeSaisie == SaisieContrat.ModeSaisie.READ_ONLY;
        this.param.messageSpecifique = PopupSaisieQteContrat.s(data.messageSpecifique);
        this.param.libButtonSave = "Continuer ...";
    }

    @Override
    public void loadParam() {
        this.param.nbLig = this.contratDTO.contratLigs.size();
        this.param.nbCol = this.contratDTO.contratColumns.size();
        this.param.cell = this.contratDTO.extractCells();
        this.param.allowedEmpty = false;
        this.param.largeurCol = 110;
        GridHeaderLine line1 = new GridHeaderLine();
        line1.addCell("Produit");
        for (ContratColDTO col : this.contratDTO.contratColumns) {
            line1.addCell(col.nomProduit, new ProduitHelpSupplier(col));
        }
        GridSizeCalculator.autoSize(line1, this.param.largeurCol, "Arial", 16);
        GridHeaderLine line2 = new GridHeaderLine();
        line2.style = GridHeaderLine.GridHeaderLineStyle.PRIX;
        line2.addCell("prix unitaire");
        for (ContratColDTO col : this.contratDTO.contratColumns) {
            line2.addCell(new CurrencyTextFieldConverter().convertToString(col.prix));
        }
        GridHeaderLine line3 = new GridHeaderLine();
        line3.addCell("Dates");
        for (ContratColDTO col : this.contratDTO.contratColumns) {
            line3.addCell(col.condtionnementProduit);
        }
        GridSizeCalculator.autoSize(line3, this.param.largeurCol, "Arial", 16);
        this.param.headerLines.add(line1);
        this.param.headerLines.add(line2);
        this.param.headerLines.add(line3);
        this.param.leftPartLineLargeur = 110;
        this.param.leftPartLineStyle = "date-saisie";
        int i = 0;
        while (i < this.param.nbLig) {
            ContratLigDTO lig = this.contratDTO.contratLigs.get(i);
            IntegerGridLine line = new IntegerGridLine();
            line.isVisible = this.computeVisible(lig);
            line.leftPart = this.df.format(lig.date);
            this.param.lines.add(line);
            ++i;
        }
        this.param.ligneCumulParam = this.computeLigneCumulParam();
        this.param.switchButtonAction = () -> this.handleSwitchButton();
    }

    private void handleSwitchButton() {
        int i = 0;
        while (i < this.param.nbLig) {
            int j = 0;
            while (j < this.param.nbCol) {
                this.contratDTO.cell[i][j].qte = this.param.cell[i][j].qte;
                ++j;
            }
            ++i;
        }
        CorePopup popup = this.computeSwitchPopup();
        this.data.insertPopup(popup);
    }

    private CorePopup computeSwitchPopup() {
        if (this.data.contratDTO.contratLigs.size() == 1) {
            return new PopupSaisieQteTable(this.data);
        }
        return new PopupSaisieQteVueListe(this.data);
    }

    private LigneCumulParam computeLigneCumulParam() {
        if (this.param.readOnly) {
            return new LigneCumulParam();
        }
        switch (this.contratDTO.nature) {
            case ABONNEMENT: 
            case LIBRE: {
                return new LigneCumulParam();
            }
            case CARTE_PREPAYEE: {
                if (this.contratDTO.paiement.gestionPaiement == GestionPaiement.NON_GERE && this.contratDTO.paiement.affichageMontant == AffichageMontant.MONTANT_PROCHAINE_LIVRAISON) {
                    LigneCumulParam p = new LigneCumulParam();
                    p.ligneCumul = TypLigneCumul.FIRST_LINE;
                    p.libCustomLigneCumul = "Montant de la livraison du " + this.param.lines.stream().filter(e -> e.isVisible).map(e -> e.leftPart).findFirst().orElse("XX");
                    return p;
                }
                LigneCumulParam p = new LigneCumulParam();
                p.ligneCumul = TypLigneCumul.STD;
                p.libCustomLigneCumul = "Montant des livraisons modifiables";
                return p;
            }
        }
        throw new AmapjRuntimeException("Nature=" + (Object)((Object)this.contratDTO.nature));
    }

    private boolean computeVisible(ContratLigDTO lig) {
        if (this.param.readOnly) {
            return true;
        }
        return lig.isModifiable;
    }

    @Override
    protected void handleContinuer() {
        this.data.validate();
        this.close();
    }

    @Override
    public boolean performSauvegarder() {
        int i = 0;
        while (i < this.param.nbLig) {
            int j = 0;
            while (j < this.param.nbCol) {
                this.contratDTO.cell[i][j].qte = this.param.cell[i][j].qte;
                ++j;
            }
            ++i;
        }
        if (!new CheckOnEndSaisieQte().check(this.data)) {
            return false;
        }
        this.data.validate();
        return true;
    }

    @Override
    public int getLineHeight(boolean readOnly) {
        return readOnly ? 26 : 32;
    }

    @Override
    public int getHeaderHeight() {
        return BaseUiTools.isCompactMode() ? 270 : 365;
    }
}

