/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.step1qte.utils.checkonend;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.service.services.gestioncontrat.reglesaisie.RegleSaisieDTO;
import fr.amapj.service.services.gestioncontrat.reglesaisie.VerifRegleSaisieResultDTO;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.popup.okcancelpopup.OKCancelPopup;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PopupRegleSaisieVisuErreur
extends OKCancelPopup {
    private VerifRegleSaisieResultDTO resultDTO;

    public PopupRegleSaisieVisuErreur(VerifRegleSaisieResultDTO resultDTO) {
        this.resultDTO = resultDTO;
        this.popupTitle = "Contrat en anomalie";
        this.saveButtonTitle = "OK";
        this.hasCancelButton = false;
        this.setWidth(50, 450);
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        if (this.resultDTO.errors.size() == 1) {
            this.displayOneError(contentLayout);
        } else {
            this.displayMutipleErrors(contentLayout);
        }
    }

    private void displayOneError(VerticalLayout contentLayout) {
        Label l1 = new Label("Ce contrat comporte une anomalie :<br/><br/>", ContentMode.HTML);
        contentLayout.addComponent((Component)l1);
        VerifRegleSaisieResultDTO.ResultDTO r = this.resultDTO.errors.get(0);
        String finalLib = this.getLib(r.regleSaisieDTO);
        Label l = new Label(finalLib, ContentMode.HTML);
        contentLayout.addComponent((Component)l);
        contentLayout.addComponent((Component)new Label("<br/>", ContentMode.HTML));
        Button b1 = new Button("D\u00e9tails");
        b1.addClickListener((Button.ClickListener & Serializable)e -> this.showDetails(r));
        contentLayout.addComponent((Component)b1);
    }

    private void displayMutipleErrors(VerticalLayout contentLayout) {
        Label l1 = new Label("Ce contrat comporte des anomalies, merci de corriger les points suivants :", ContentMode.HTML);
        contentLayout.addComponent((Component)l1);
        List<VerifRegleSaisieResultDTO.ResultDTO> regleSaisies = this.resultDTO.errors;
        int i = 0;
        while (i < regleSaisies.size()) {
            VerifRegleSaisieResultDTO.ResultDTO r = regleSaisies.get(i);
            HorizontalLayout hl = new HorizontalLayout();
            hl.setWidth("100%");
            String finalLib = this.getLib(r.regleSaisieDTO);
            Label l = new Label("<b>" + (i + 1) + " :</b>" + finalLib, ContentMode.HTML);
            hl.addComponent((Component)l);
            hl.setExpandRatio((Component)l, 1.0f);
            Button b1 = new Button("D\u00e9tails");
            b1.addClickListener((Button.ClickListener & Serializable)e -> this.showDetails(r));
            hl.addComponent((Component)b1);
            contentLayout.addComponent((Component)hl);
            contentLayout.addComponent((Component)new Label(""));
            ++i;
        }
    }

    private String getLib(RegleSaisieDTO regleSaisieDTO) {
        if (regleSaisieDTO.activateLibPersonnalise == ChoixOuiNon.OUI) {
            return regleSaisieDTO.libPersonnalise;
        }
        return regleSaisieDTO.libelle;
    }

    private void showDetails(VerifRegleSaisieResultDTO.ResultDTO r) {
        ArrayList<String> ls = new ArrayList<String>();
        if (r.regleSaisieDTO.activateLibPersonnalise == ChoixOuiNon.OUI) {
            ls.add(r.regleSaisieDTO.libelle);
        }
        ls.addAll(r.msgs);
        new MessagePopup("D\u00e9tails", ContentMode.HTML, CorePopup.ColorStyle.GREEN, ls).open();
    }

    @Override
    protected boolean performSauvegarder() {
        return true;
    }

    public static boolean performCheck(SaisieContrat.SaisieContratData data) {
        if (data.verifRegleSaisieDTO == null) {
            return true;
        }
        VerifRegleSaisieResultDTO res = data.verifRegleSaisieDTO.performCheck();
        if (!res.isValid()) {
            new PopupRegleSaisieVisuErreur(res).open();
            return false;
        }
        return true;
    }
}

