/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.step2paiement;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.models.contrat.modele.AffichageMontant;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.service.services.mescontrats.InfoPaiementDTO;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PopupInfoPaiement
extends CorePopup {
    private SimpleDateFormat df = FormatUtils.getStdDate();
    private InfoPaiementDTO paiementDTO;
    private SaisieContrat.SaisieContratData data;

    public PopupInfoPaiement(SaisieContrat.SaisieContratData data) {
        this.data = data;
        this.paiementDTO = data.contratDTO.paiement;
        this.popupTitle = "Information sur les paiements pour le contrat " + data.contratDTO.nom;
        this.setWidth(50);
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        boolean readOnly;
        this.addMontantPart(contentLayout);
        contentLayout.addComponent((Component)new Label(this.paiementDTO.textPaiement));
        boolean bl = readOnly = this.data.modeSaisie == SaisieContrat.ModeSaisie.READ_ONLY;
        if (!readOnly) {
            String str = "<br/><br/>Veuillez maintenant cliquer sur " + this.data.getLibSaveButton() + " pour valider votre contrat, " + "ou sur Annuler si vous ne souhaitez pas conserver ce contrat<br/><br/>";
            contentLayout.addComponent((Component)new Label(str, ContentMode.HTML));
        }
    }

    private void addMontantPart(VerticalLayout contentLayout) {
        if (this.paiementDTO.affichageMontant == AffichageMontant.AUCUN_AFFICHAGE) {
            return;
        }
        if (this.data.contratDTO.contratLigs.size() == 1) {
            String mnt = this.getMontantTotalLib();
            contentLayout.addComponent((Component)new Label(mnt, ContentMode.HTML));
            return;
        }
        HorizontalLayout hl = new HorizontalLayout();
        hl.setWidth("100%");
        String mnt = this.computeLibMontant();
        Label l = new Label(mnt, ContentMode.HTML);
        hl.addComponent((Component)l);
        hl.setExpandRatio((Component)l, 1.0f);
        Button details = new Button("D\u00e9tails");
        details.addClickListener((Button.ClickListener & Serializable)e -> this.handleDetails());
        hl.addComponent((Component)details);
        contentLayout.addComponent((Component)hl);
    }

    private String computeLibMontant() {
        if (this.paiementDTO.affichageMontant == AffichageMontant.MONTANT_TOTAL) {
            return this.getMontantTotalLib();
        }
        Date nextDatLiv = this.getNextDateLiv();
        if (nextDatLiv != null) {
            return "<b>Montant de la prochaine livraison (" + this.df.format(nextDatLiv) + ")  : " + FormatUtils.prix(this.data.contratDTO.getMontantOf(nextDatLiv)) + "</b><br/><br/>";
        }
        Date lastDateLiv = this.getLastDateLiv();
        return "<b>Montant de la derni\u00e8re livraison (" + this.df.format(lastDateLiv) + ")  : " + FormatUtils.prix(this.data.contratDTO.getMontantOf(lastDateLiv)) + "</b><br/><br/>";
    }

    private Date getLastDateLiv() {
        return this.data.contratDTO.contratLigs.get((int)(this.data.contratDTO.contratLigs.size() - 1)).date;
    }

    private Date getNextDateLiv() {
        Date ref = DateUtils.getDateWithNoTime();
        for (ContratLigDTO contratLigDTO : this.data.contratDTO.contratLigs) {
            if (contratLigDTO.date.before(ref)) continue;
            return contratLigDTO.date;
        }
        return null;
    }

    private String getMontantTotalLib() {
        return "<b>Montant total du contrat : " + FormatUtils.prix(this.data.contratDTO.getMontantTotal()) + "</b><br/><br/>";
    }

    private void handleDetails() {
        String msg = this.computeDetails();
        new MessagePopup("D\u00e9tails du paiement par date", ContentMode.HTML, CorePopup.ColorStyle.GREEN, msg).open();
    }

    private String computeDetails() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.data.contratDTO.contratLigs.size()) {
            ContratLigDTO lig = this.data.contratDTO.contratLigs.get(i);
            sb.append("Montant command\u00e9 pour le " + this.df.format(lig.date) + " : ");
            int mnt = 0;
            int j = 0;
            while (j < this.data.contratDTO.contratColumns.size()) {
                int prix = this.data.contratDTO.contratColumns.get((int)j).prix;
                mnt += this.data.contratDTO.cell[i][j].qte * prix;
                ++j;
            }
            sb.append("<b>" + FormatUtils.prix(mnt) + "</b><br/>");
            ++i;
        }
        sb.append("<br/>");
        sb.append("Motant total du contrat : ");
        sb.append("<b>" + FormatUtils.prix(this.data.contratDTO.getMontantTotal()) + "</b><br/>");
        return sb.toString();
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        if (this.data.modeSaisie == SaisieContrat.ModeSaisie.READ_ONLY) {
            this.addDefaultButton("OK", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
        } else {
            this.addButton("Annuler", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
            this.addDefaultButton(this.data.getLibSaveButton(), (Button.ClickListener & Serializable)e -> this.handleSauvegarder());
        }
    }

    protected void handleAnnuler() {
        this.close();
    }

    public void handleSauvegarder() {
        this.data.validate();
        this.close();
    }
}

