/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.step2paiement;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.models.contrat.modele.SaisiePaiementProposition;
import fr.amapj.service.services.mescontrats.DatePaiementDTO;
import fr.amapj.service.services.mescontrats.InfoPaiementDTO;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropositionPaiement {
    private static final Logger logger = LogManager.getLogger();
    private InfoPaiementDTO paiementDTO;
    private SaisieContrat.SaisieContratData data;
    private int montantCible;

    public PropositionPaiement(SaisieContrat.SaisieContratData data) {
        this.data = data;
        this.paiementDTO = data.contratDTO.paiement;
        this.montantCible = data.contratDTO.getMontantTotal();
    }

    public void computePropositionPaiement() {
        if (this.data.modeSaisie == SaisieContrat.ModeSaisie.READ_ONLY) {
            return;
        }
        if (this.data.modeSaisie == SaisieContrat.ModeSaisie.CHEQUE_SEUL) {
            return;
        }
        int nbModifiable = this.paiementDTO.getNbModifiable();
        logger.info("nbModifiable = " + nbModifiable);
        if (nbModifiable == 0) {
            throw new AmapjRuntimeException("Impossible de continuer : il n'est plus possible de modifier les ch\u00e9ques");
        }
        if (nbModifiable == 1) {
            DatePaiementDTO line = this.paiementDTO.getLastModifiable();
            line.montant = line.montant + this.montantCible - this.paiementDTO.getMontantTotalPaiement();
            return;
        }
        List<DatePaiementDTO> lines = this.paiementDTO.getAllModifiableLineExceptLast();
        logger.info("lines AllModifiableLineExceptLast - size = " + lines.size());
        switch (this.paiementDTO.saisiePaiementProposition) {
            case PAYE_AVANCE_STRICT: 
            case PAYE_AVANCE_ARRONDI: {
                this.performPayeAvance(lines);
                break;
            }
            case REPARTI_ARRONDI: {
                this.performRepartiArrondi(lines);
                break;
            }
            case REPARTI_STRICT: {
                this.performRepartiStrict(lines);
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
    }

    private void performPayeAvance(List<DatePaiementDTO> lines) {
        for (DatePaiementDTO line : lines) {
            Date nextPaiementDate = this.paiementDTO.getNextDatePaiement(line);
            int montantConsomme = this.data.contratDTO.getMontantTotalBefore(nextPaiementDate);
            int montantPaye = this.paiementDTO.getMontantPayeBefore(line);
            int montantRestantAPayer = this.montantCible - montantPaye;
            line.montant = montantPaye >= montantConsomme ? 0 : this.roundIfNeedPayeAvance(montantConsomme - montantPaye, montantRestantAPayer);
        }
        this.performAdjust(this.montantCible);
    }

    private int roundIfNeedPayeAvance(int montant, int montantRestantAPayer) {
        if (this.paiementDTO.saisiePaiementProposition == SaisiePaiementProposition.PAYE_AVANCE_STRICT) {
            return montant;
        }
        int montantMini = this.paiementDTO.montantChequeMiniCalculProposition;
        int mntArrondi = this.arrondiEuroSuperieur(montant);
        int m1 = Math.max(mntArrondi, montantMini);
        int m2 = Math.min(montantRestantAPayer, m1);
        int reliquat = montantRestantAPayer - m2;
        if (reliquat < montantMini) {
            return montantRestantAPayer;
        }
        return m2;
    }

    private void performRepartiArrondi(List<DatePaiementDTO> lines) {
        int nbModifiable = this.paiementDTO.getNbModifiable();
        int montantAPaye = this.montantCible - this.paiementDTO.getMontantNonModifiable();
        int montant = this.computeMontantPart();
        int montantAffecte = 0;
        logger.info("Montant Part=" + montant);
        int i = 0;
        while (i < lines.size()) {
            DatePaiementDTO line = lines.get(i);
            int montantRestantAPayer = this.montantCible - this.paiementDTO.getMontantPayeBefore(line);
            int montantCible = (i + 1) * montantAPaye / nbModifiable;
            line.montant = montantAffecte >= montantCible ? 0 : Math.min(montant, montantRestantAPayer);
            montantAffecte += line.montant;
            ++i;
        }
        this.performAdjust(this.montantCible);
    }

    private int computeMontantPart() {
        int montantMini = this.paiementDTO.montantChequeMiniCalculProposition;
        int nbModifiable = this.paiementDTO.getNbModifiable();
        int montantAPaye = this.montantCible - this.paiementDTO.getMontantNonModifiable();
        if (montantMini == 0) {
            int montantPart = this.arrondiEuroSuperieur(montantAPaye / nbModifiable);
            return montantPart;
        }
        int nbPaiementMaxi = montantAPaye / montantMini;
        int nbPaiement = Math.min(nbPaiementMaxi, nbModifiable);
        if (nbPaiement == 0) {
            return montantAPaye;
        }
        int montantPart = this.arrondiEuroSuperieur(montantAPaye / nbPaiement);
        return montantPart;
    }

    private void performRepartiStrict(List<DatePaiementDTO> lines) {
        int nbPart = this.paiementDTO.getNbModifiable();
        int montantAPaye = this.montantCible - this.paiementDTO.getMontantNonModifiable();
        int montant = montantAPaye / nbPart;
        int i = 0;
        while (i < lines.size()) {
            DatePaiementDTO line = lines.get(i);
            line.montant = montant;
            ++i;
        }
        this.performAdjust(this.montantCible);
    }

    private int arrondiEuroSuperieur(int montant) {
        if (montant % 100 == 0) {
            return montant;
        }
        return montant / 100 * 100 + 100;
    }

    public void performAdjust(int montantCible) {
        DatePaiementDTO line = this.paiementDTO.getLastModifiable();
        line.montant = line.montant + montantCible - this.paiementDTO.getMontantTotalPaiement();
    }
}

