/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.searcher;

import fr.amapj.model.engine.Identifiable;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceUtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.searcher.SearcherDefinition;
import java.util.ArrayList;
import java.util.List;

public class SDUtilisateurPeriodePermanence
implements SearcherDefinition {
    private PeriodePermanenceDTO dto;
    private List<PeriodePermanenceUtilisateurDTO> toExclude;

    public SDUtilisateurPeriodePermanence(PeriodePermanenceDTO dto, List<PeriodePermanenceUtilisateurDTO> toExclude) {
        this.dto = dto;
        this.toExclude = toExclude;
    }

    @Override
    public String getTitle() {
        return "Adh\u00e9rent";
    }

    @Override
    public List<? extends Identifiable> getAllElements(Object params) {
        ArrayList<Utilisateur> res = new ArrayList<Utilisateur>();
        List<Utilisateur> us = new UtilisateurService().getUtilisateurs(EtatUtilisateur.ACTIF);
        for (Utilisateur utilisateur : us) {
            if (this.isAlreadyIn(utilisateur.getId())) continue;
            res.add(utilisateur);
        }
        return res;
    }

    private boolean isAlreadyIn(Long idUtilisateur) {
        for (PeriodePermanenceUtilisateurDTO detail : this.dto.utilisateurs) {
            if (detail.idUtilisateur != idUtilisateur) continue;
            return true;
        }
        for (PeriodePermanenceUtilisateurDTO detail : this.toExclude) {
            if (detail.idUtilisateur != idUtilisateur) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString(Identifiable identifiable) {
        Utilisateur u = (Utilisateur)identifiable;
        return String.valueOf(u.nom) + " " + u.prenom;
    }
}

