/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.sendmail;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.RichTextArea;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.service.services.mailer.MailerMessage;
import fr.amapj.service.services.mailer.MailerService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.template.BackOfficeLongView;
import java.io.Serializable;

public class SendMailView
extends BackOfficeLongView
implements View {
    TextField titre;
    TextField destinataires;
    RichTextArea zoneTexte;

    @Override
    public String getMainStyleName() {
        return "sendmail";
    }

    @Override
    public void enterIn(ViewChangeListener.ViewChangeEvent event) {
        ParametresDTO param = new ParametresService().getParametres();
        SendMailView layout = this;
        this.addLabel(layout, "Cet outil permet d'envoyer un mail \u00e0 des fins de tests vers un destinataire unique.");
        this.addLabel(layout, "Cet outil permet de tester le bon fonctionnement de l'envoi des mails par l'administrateur informatique.");
        this.addLabel(layout, "Cet outil ne doit pas \u00eatre utilis\u00e9 dans un but autre que le test.");
        this.addEmptyLine(layout);
        TextField expediteur = this.addTextField(layout, "Exp\u00e9diteur du mail");
        expediteur.setEnabled(false);
        expediteur.setValue(param.sendingMailUsername);
        this.titre = this.addTextField(layout, "Titre du mail");
        this.destinataires = this.addTextField(layout, "Destinataire du mail");
        this.zoneTexte = new RichTextArea("Message");
        this.zoneTexte.setWidth("100%");
        this.zoneTexte.setHeight("500px");
        layout.addComponent((Component)this.zoneTexte);
        this.addButton((Layout)layout, "Envoyer", (Button.ClickListener & Serializable)e -> this.handleEnvoyerMail());
    }

    private TextField addTextField(VerticalLayout layout, String lib) {
        HorizontalLayout h = new HorizontalLayout();
        h.setSpacing(true);
        TextField tf = new TextField();
        tf.setWidth("500px");
        Label l = new Label(lib);
        l.setWidth("150px");
        h.addComponent((Component)l);
        h.addComponent((Component)tf);
        layout.addComponent((Component)h);
        return tf;
    }

    private void handleEnvoyerMail() {
        String email = (String)this.destinataires.getValue();
        String subject = (String)this.titre.getValue();
        String htmlContent = (String)this.zoneTexte.getValue();
        new MailerService().sendHtmlMail(new MailerMessage(email, subject, htmlContent));
        Notification.show((String)("Message envoy\u00e9 \u00e0 " + email));
    }

    private void addButton(Layout layout, String str, Button.ClickListener listener) {
        Button b = new Button(str);
        b.addStyleName("primary");
        b.addClickListener(listener);
        layout.addComponent((Component)b);
    }

    private Label addLabel(VerticalLayout layout, String str) {
        Label tf = new Label(str);
        layout.addComponent((Component)tf);
        return tf;
    }

    private Label addEmptyLine(VerticalLayout layout) {
        Label tf = new Label("<br/>", ContentMode.HTML);
        layout.addComponent((Component)tf);
        return tf;
    }
}

