/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.stock;

import fr.amapj.common.FormatUtils;
import fr.amapj.model.models.produitextended.qtedispostock.QteDispoStock;
import fr.amapj.service.services.stockservice.saisie.SaisieStockDTO;
import fr.amapj.service.services.stockservice.saisie.SaisieStockService;
import fr.amapj.service.services.stockservice.verifstock.ProduitEnStockDTO;
import fr.amapj.view.engine.grid.GridHeaderLine;
import fr.amapj.view.engine.grid.GridSizeCalculator;
import fr.amapj.view.engine.grid.integergrid.IntegerGridCell;
import fr.amapj.view.engine.grid.integergrid.IntegerGridLine;
import fr.amapj.view.engine.grid.integergrid.PopupIntegerGrid;
import fr.amapj.view.engine.grid.integergrid.lignecumul.TypLigneCumul;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.stock.SaisieQteStock;
import java.util.List;

public class PopupSaisieQteStockMemeDate
extends PopupIntegerGrid {
    private int largeurColonne = 500;
    private QteDispoStock qteDispoStock;
    private List<ProduitEnStockDTO> prods;
    private SaisieStockDTO saisieStockDTO;

    public PopupSaisieQteStockMemeDate(SaisieStockDTO saisieStockDTO) {
        this.saisieStockDTO = saisieStockDTO;
        this.qteDispoStock = saisieStockDTO.qteDispoStock;
        this.prods = saisieStockDTO.verifStockDTO.verifStockDateDTO.prodStocks;
        this.popupTitle = "Saisie des quantit\u00e9s limites";
        this.param.readOnly = false;
        this.param.allowedEmpty = true;
        this.param.libButtonSave = "Sauvegarder";
        this.param.messageSpecifique = SaisieQteStock.computeHeader(saisieStockDTO);
    }

    @Override
    public void loadParam() {
        this.param.nbLig = this.prods.size();
        this.param.nbCol = 1;
        this.computeCells();
        this.param.buttonCopyFirstLine = false;
        this.param.ligneCumulParam.ligneCumul = TypLigneCumul.NO;
        this.param.largeurCol = 110;
        GridHeaderLine line1 = new GridHeaderLine();
        line1.addCell("Produit");
        line1.addCell("Qte");
        this.param.headerLines.add(line1);
        this.param.leftPartLineLargeur = this.largeurColonne;
        this.param.leftPartLineStyle = "description-panier";
        for (ProduitEnStockDTO prod : this.prods) {
            IntegerGridLine line = new IntegerGridLine();
            line.isVisible = true;
            line.leftPart = this.getText(prod);
            this.param.lines.add(line);
        }
    }

    private void computeCells() {
        this.param.cell = new IntegerGridCell[this.prods.size()][1];
        int j = 0;
        while (j < this.prods.size()) {
            IntegerGridCell c = new IntegerGridCell();
            c.isStaticText = false;
            c.qte = this.prods.get((int)j).qteDispo[0];
            c.prix = 0;
            this.param.cell[j][0] = c;
            ++j;
        }
    }

    private String getText(ProduitEnStockDTO prod) {
        String str = String.valueOf(this.getLine1(prod)) + "<br/>";
        str = String.valueOf(str) + "Prix unitaire : " + FormatUtils.prix(prod.prix);
        return str;
    }

    private String getLine1(ProduitEnStockDTO prod) {
        return String.valueOf(prod.nomProduit) + "," + prod.condtionnementProduit;
    }

    @Override
    public boolean performSauvegarder() {
        this.updateFromSaisie();
        new SaisieStockService().saveStockInfo(this.saisieStockDTO);
        return true;
    }

    private void updateFromSaisie() {
        int j = 0;
        while (j < this.prods.size()) {
            int qteSaisie = this.param.cell[j][0].qte;
            this.qteDispoStock.updateQteMaxiStockIdentiqueDate(this.prods.get((int)j).idProduit, qteSaisie);
            ++j;
        }
    }

    @Override
    public int getLineHeight(boolean readOnly) {
        int nbLineMax = this.getNbLineMax();
        return (nbLineMax + 1) * 16 + 10 + 10;
    }

    private int getNbLineMax() {
        int nbLine = 1;
        GridSizeCalculator cal = new GridSizeCalculator();
        for (ProduitEnStockDTO col : this.prods) {
            String cell = this.getLine1(col);
            nbLine = Math.max(nbLine, cal.getHeight(cell, this.largeurColonne - 22, "Arial", 16));
        }
        return nbLine;
    }

    @Override
    public int getHeaderHeight() {
        return BaseUiTools.isCompactMode() ? 185 : 284;
    }
}

