/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.utilisateur;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.TextArea;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.service.services.utilisateur.envoimail.EnvoiMailDTO;
import fr.amapj.service.services.utilisateur.envoimail.EnvoiMailUtilisateurDTO;
import fr.amapj.service.services.utilisateur.envoimail.StatusEnvoiMailDTO;
import fr.amapj.view.engine.collectioneditor.CollectionEditor;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.views.searcher.SearcherList;

public class PopupEnvoiPasswordMasse
extends WizardFormPopup {
    private EnvoiMailDTO envoiMail;

    public PopupEnvoiPasswordMasse() {
        this.setWidth(80);
        this.popupTitle = "Envoi des mots de passe en masse";
        this.saveButtonTitle = "Quitter";
        this.envoiMail = new UtilisateurService().getEnvoiMailDTO();
        this.envoiMail.texteMail = this.getInitialText();
        this.setModel(this.envoiMail);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldUtilisateurs());
        this.add(() -> this.addFieldTexteMail());
        this.add(() -> this.addFieldAvertissement());
        this.add(() -> this.addFieldResultat());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va vous permettre d'envoyer un mail de bienvenue avec un password et une adresse de connexion</br>\u00e0 tous les utilisateurs qui n'ont pas de mot de passe<br/><br/>Sur l'\u00e9cran suivant, vous allez visualiser la liste des personnes qui vont recevoir ce message <br/><br/>Sur l'\u00e9cran encore suivant, vous pourrez saisir le texte du message qui sera envoy\u00e9<br/>";
        this.addHtml(str);
    }

    private void addFieldUtilisateurs() {
        this.setStepTitle("les utilisateurs qui vont recevoir le mail de bienvenue");
        CollectionEditor<EnvoiMailUtilisateurDTO> f1 = this.addCollectionEditorField("Liste des utilisateurs", "utilisateurs", EnvoiMailUtilisateurDTO.class, new IValidator[0]);
        f1.addSearcherColumn("idUtilisateur", "Nom de l'utilisateur", FieldType.SEARCHER, null, SearcherList.UTILISATEUR_ACTIF, null);
        f1.addColumn("sendMail", "Envoyer un mail", FieldType.CHECK_BOX, true);
    }

    private void addFieldTexteMail() {
        this.setStepTitle("le texte du mail de bienvenue");
        TextArea f = this.addTextAeraField("Texte du mail", "texteMail");
        f.setMaxLength(20480);
        f.setHeight(10.0f, Sizeable.Unit.CM);
    }

    private void addFieldAvertissement() {
        this.setStepTitle("Etes vous s\u00fbr ? ");
        int count = 0;
        for (EnvoiMailUtilisateurDTO u : this.envoiMail.utilisateurs) {
            if (!u.sendMail) continue;
            ++count;
        }
        String str = "Vous allez envoyer " + count + " mails.</br>" + "Etes vous s\u00fbr de vouloir continuer ?<br/>" + "Quand vous allez cliquer sur Etape suivante, les mails seront envoy\u00e9s<br/>";
        this.addHtml(str);
    }

    private void addFieldResultat() {
        StatusEnvoiMailDTO ret = new UtilisateurService().envoiEmailBienvenue(this.envoiMail);
        this.setStepTitle("R\u00e9sultats");
        String str = String.valueOf(ret.nbMailOK) + " mails ont \u00e9t\u00e9 envoy\u00e9s avec succ\u00e9s";
        this.addHtml(str);
        if (ret.erreurs.size() > 0) {
            str = "Il y a eu " + ret.erreurs.size() + " erreurs.</br></br>";
            for (String err : ret.erreurs) {
                str = String.valueOf(str) + err + "</br>";
            }
            this.addHtml(str);
        }
        this.previousButton.setEnabled(false);
    }

    @Override
    protected void performSauvegarder() {
    }

    private String getInitialText() {
        String lineSep = "\r\n";
        ParametresDTO param = new ParametresService().getParametres();
        StringBuffer buf = new StringBuffer();
        buf.append("<h2>" + param.nomAmap + "</h2>");
        buf.append(lineSep);
        buf.append("Bonjour , voici vos identifiants pour vous connecter \u00e0 l'application WEB de :" + param.nomAmap);
        buf.append(lineSep);
        buf.append(lineSep);
        buf.append("Adresse e mail : #EMAIL#");
        buf.append(lineSep);
        buf.append(lineSep);
        buf.append("Mot de passe : #PASSWORD#");
        buf.append(lineSep);
        buf.append(lineSep);
        buf.append("<a href=\"#LINK#\">Cliquez ici pour acc\u00e9der \u00e0 l'application</a>");
        buf.append(lineSep);
        buf.append(lineSep);
        buf.append("Merci de conserver ce lien pour pouvoir vous reconnecter plus tard.");
        buf.append(lineSep);
        buf.append("Si vous souhaitez changer votre mot de passe, vous pourrez le faire en vous connectant dans l'application, puis en allant dans le menu \"Mon Compte\"");
        buf.append(lineSep);
        buf.append(lineSep);
        buf.append(lineSep);
        buf.append(lineSep);
        buf.append("Bonne journ\u00e9e \u00e0 tous !!");
        buf.append(lineSep);
        return buf.toString();
    }
}

