/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.utilisateur;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Notification;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.errorpopup.ErrorPopup;
import fr.amapj.view.engine.popup.formpopup.FormPopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.popup.suppressionpopup.UnableToSuppressException;

public class PopupSuppressionUtilisateur
extends FormPopup {
    private UtilisateurDTO utilisateurDTO;

    public PopupSuppressionUtilisateur(UtilisateurDTO utilisateurDTO) {
        this.popupTitle = "Suppression d'un utilisateur";
        this.utilisateurDTO = utilisateurDTO;
        this.setModel(utilisateurDTO);
    }

    @Override
    protected void addFields() {
        this.addText("Etes vous s\u00fbr de vouloir supprimer l' utilisateur " + this.utilisateurDTO.nom + " " + this.utilisateurDTO.prenom + " ?");
    }

    @Override
    protected void performSauvegarder() {
        try {
            new UtilisateurService().deleteUtilisateur(this.utilisateurDTO.id);
            Notification.show((String)"Suppression", (String)"Suppression faite", (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
        }
        catch (UnableToSuppressException e) {
            String title = "Erreur \u00e0 la suppression";
            String t1 = "Impossible de supprimer cet \u00e9l\u00e9ment. Raison :";
            String t2 = e.getMessage();
            MessagePopup popup = new MessagePopup(title, ContentMode.HTML, CorePopup.ColorStyle.RED, t1, t2);
            CorePopup.open(popup);
        }
        catch (Exception e) {
            ErrorPopup.open("Impossible de supprimer cet element.", e);
        }
    }
}

