/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.utilisateur;

import com.vaadin.ui.Component;
import fr.amapj.common.FormatUtils;
import fr.amapj.service.services.access.AccessManagementService;
import fr.amapj.service.services.edgenerator.excel.amapien.EGBilanCompletAmapien;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import java.text.SimpleDateFormat;
import java.util.List;

public class PopupUtilisateurVoirPart
extends WizardFormPopup {
    private UtilisateurDTO utilisateurDTO;

    public PopupUtilisateurVoirPart(Long idUtilisateur) {
        this.setWidth(80);
        this.popupTitle = "Visualisation d'un utilisateur";
        this.saveButtonTitle = "OK";
        this.utilisateurDTO = new UtilisateurService().loadUtilisateurDto(idUtilisateur);
        this.setModel(this.utilisateurDTO);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldBasic());
        this.add(() -> this.addFieldAutres());
    }

    protected void addFieldBasic() {
        this.setStepTitle("Informations g\u00e9n\u00e9rales");
        this.addTextField("Nom", "nom", new IValidator[0]).setReadOnly(true);
        this.addTextField("Prenom", "prenom", new IValidator[0]).setReadOnly(true);
        this.addTextField("E mail", "email", new IValidator[0]).setReadOnly(true);
        this.addTextField("T\u00e9l\u00e9phone 1", "numTel1", new IValidator[0]).setReadOnly(true);
        this.addTextField("T\u00e9l\u00e9phone 2", "numTel2", new IValidator[0]).setReadOnly(true);
        this.addTextField("Adresse", "libAdr1", new IValidator[0]).setReadOnly(true);
        this.addTextField("Code postal", "codePostal", new IValidator[0]).setReadOnly(true);
        this.addTextField("Ville", "ville", new IValidator[0]).setReadOnly(true);
    }

    protected void addFieldAutres() {
        this.setStepTitle("Informations sur les contrats et les r\u00f4les");
        String str = PopupUtilisateurVoirPart.getInfoUtilisateur(this.utilisateurDTO);
        this.addHtml(str);
        this.form.addComponent((Component)LinkCreator.createLink(new EGBilanCompletAmapien(this.utilisateurDTO.id)));
    }

    public static String getInfoUtilisateur(UtilisateurDTO utilisateurDTO) {
        String str = "Nombre de contrats de cet utilisateur : " + new UtilisateurService().countContrat(utilisateurDTO.id) + "</br></br>";
        List<String> roles = new AccessManagementService().detailDesRoles(utilisateurDTO.id);
        for (String role : roles) {
            str = String.valueOf(str) + role + "<br/>";
        }
        str = String.valueOf(str) + "<br/>";
        SimpleDateFormat df = FormatUtils.getTimeStd();
        str = String.valueOf(str) + "Date de cr\u00e9ation de cet utilisateur: " + df.format(utilisateurDTO.dateCreation) + "<br/>" + "Date de derni\u00e8re modification : ";
        if (utilisateurDTO.dateModification != null) {
            str = String.valueOf(str) + df.format(utilisateurDTO.dateModification);
        }
        str = String.valueOf(str) + "<br/>";
        return str;
    }

    @Override
    protected void performSauvegarder() {
    }
}

