/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.utilisateur;

import com.vaadin.ui.Component;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.service.services.edgenerator.excel.EGListeAdherent;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.swicthpopup.SwitchPopup;
import fr.amapj.view.views.common.amapientelecharger.TelechargerAmapien;
import fr.amapj.view.views.utilisateur.CreationUtilisateurEditorPart;
import fr.amapj.view.views.utilisateur.ModificationUtilisateurEditorPart;
import fr.amapj.view.views.utilisateur.PopupEnvoiPasswordMasse;
import fr.amapj.view.views.utilisateur.PopupRendreActifUtilisateurMasse;
import fr.amapj.view.views.utilisateur.PopupSaisiePassword;
import fr.amapj.view.views.utilisateur.PopupSuppressionUtilisateur;
import fr.amapj.view.views.utilisateur.PopupUtilisateurArchiver;
import fr.amapj.view.views.utilisateur.PopupUtilisateurVoirPart;
import java.util.List;

public class UtilisateurListPart
extends StandardListPart<UtilisateurDTO> {
    public UtilisateurListPart() {
        super(UtilisateurDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des utilisateurs";
    }

    @Override
    protected void drawButton() {
        this.addButton("Cr\u00e9er un nouvel utilisateur", ButtonType.ALWAYS, e -> new CreationUtilisateurEditorPart());
        this.addButton("Modifier", ButtonType.EDIT_MODE, e -> new ModificationUtilisateurEditorPart(e.id));
        this.addButton("Voir", ButtonType.EDIT_MODE, e -> new PopupUtilisateurVoirPart(e.id));
        this.addButton("Changer le mot de passe", ButtonType.EDIT_MODE, e -> new PopupSaisiePassword(e.id));
        this.addButton("Archiver", ButtonType.EDIT_MODE, e -> new PopupUtilisateurArchiver((UtilisateurDTO)e));
        this.addButton("T\u00e9l\u00e9charger", ButtonType.EDIT_MODE, e -> TelechargerAmapien.handleTelecharger(e.id));
        this.addButton("Autre...", ButtonType.ALWAYS, e -> this.handleMore());
        this.addSearchField("Rechercher par nom ou pr\u00e9nom");
    }

    @Override
    protected void addExtraComponent() {
        this.addComponent((Component)LinkCreator.createLink(new EGListeAdherent(EGListeAdherent.Type.STD)));
    }

    @Override
    protected void drawTable() {
        this.addColumn("nom", "Nom");
        this.addColumn("prenom", "Prenom");
        this.addColumn("roles", "Role");
        this.addColumn("etatUtilisateur", "Etat");
        this.addColumnDateTime("dateCreation", "Date cr\u00e9ation");
    }

    @Override
    protected List<UtilisateurDTO> getLines() {
        return new UtilisateurService().getAllUtilisateurs(EtatUtilisateur.ACTIF);
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nom", "prenom"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom", "prenom"};
    }

    private CorePopup handleMore() {
        UtilisateurDTO dto = (UtilisateurDTO)this.getSelectedLine();
        SwitchPopup popup = new SwitchPopup("Autres actions sur les utilisateurs", 50);
        if (dto != null) {
            popup.addLine("Supprimer l'utilisateur " + dto.nom + " " + dto.prenom, () -> new PopupSuppressionUtilisateur(dto));
            popup.addSeparator();
        }
        popup.addLine("Rendre actif les utilisateurs en masse", () -> new PopupRendreActifUtilisateurMasse(true));
        popup.addLine("Rendre inactif les utilisateurs en masse", () -> new PopupRendreActifUtilisateurMasse(false));
        popup.addSeparator();
        popup.addLine("Envoyer un e mail de bienvenue avec un mot de passe pour tous les utilisateurs sans mot de passe ", () -> new PopupEnvoiPasswordMasse());
        return popup;
    }
}

