/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.visiteamap;

import com.vaadin.ui.Button;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.model.models.param.paramecran.PEVisiteAmap;
import fr.amapj.service.services.listeproducteurreferent.DetailProducteurDTO;
import fr.amapj.service.services.listeproducteurreferent.DetailRequestDTO;
import fr.amapj.service.services.listeproducteurreferent.ListeProducteurReferentService;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.visiteamap.VisiteAmapDTO;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import java.io.Serializable;

public class ProducteurPopupInfo
extends CorePopup {
    private Long idProducteur;

    public ProducteurPopupInfo(VisiteAmapDTO.Producteur producteur) {
        this.setWidth(60, 960);
        this.setCloseable(false);
        this.idProducteur = producteur.contrats.get((int)0).ligneContrats.get((int)0).producteurId;
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.addButton("OK", (Button.ClickListener & Serializable)e -> this.close());
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        PEVisiteAmap pe = (PEVisiteAmap)new ParametresService().loadParamEcran(MenuList.VISITE_AMAP);
        DetailRequestDTO r = new DetailRequestDTO();
        r.producteurEmail = pe.producteurEmail;
        r.producteurTel1 = pe.producteurTel1;
        r.producteurTel2 = pe.producteurTel2;
        r.referentEmail = pe.referentEmail;
        r.referentTel1 = pe.referentTel1;
        r.referentTel2 = pe.referentTel2;
        DetailProducteurDTO detailProducteurDTO = new ListeProducteurReferentService().getOneProducteur(this.idProducteur, r);
        contentLayout.addStyleName("popup-visite");
        BaseUiTools.addBandeau((Layout)contentLayout, ProducteurPopupInfo.s(detailProducteurDTO.nom), "nomproducteur");
        BaseUiTools.addEmptyLine((Layout)contentLayout);
        if (pe.infoProducteurModeAffichage == PEVisiteAmap.InfoProducteurModeAffichage.DESCRIPTION_PUIS_CONTACT) {
            BaseUiTools.addHtmlLabel((Layout)contentLayout, ProducteurPopupInfo.s(detailProducteurDTO.description), "");
            BaseUiTools.addEmptyLine((Layout)contentLayout);
            BaseUiTools.addBandeau((Layout)contentLayout, detailProducteurDTO.contacts, "contact");
        } else {
            BaseUiTools.addBandeau((Layout)contentLayout, detailProducteurDTO.contacts, "contact");
            BaseUiTools.addEmptyLine((Layout)contentLayout);
            BaseUiTools.addHtmlLabel((Layout)contentLayout, ProducteurPopupInfo.s(detailProducteurDTO.description), "");
        }
    }
}

