/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.visiteamap;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.GenericUtils;
import fr.amapj.model.models.param.paramecran.PEVisiteAmap;
import fr.amapj.service.services.mescontrats.small.SmallContratDTO;
import fr.amapj.service.services.meslivraisons.QteProdDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.service.services.visiteamap.VisiteAmapDTO;
import fr.amapj.service.services.visiteamap.VisiteAmapService;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.template.FrontOfficeView;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.common.gapviewer.AbstractGapViewer;
import fr.amapj.view.views.common.gapviewer.GapViewerUtil;
import fr.amapj.view.views.mescontrats.InscriptionButtonModule;
import fr.amapj.view.views.visiteamap.ProducteurPopupInfo;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class VisiteAmapView
extends FrontOfficeView {
    private VerticalLayout mainVerticalLayout;
    private AbstractGapViewer semaineViewer;
    private SimpleDateFormat df1 = FormatUtils.getFullDate();
    private boolean compactMode = false;
    private Button toggleButtonCompactMode;

    @Override
    public String getMainStyleName() {
        return "visite";
    }

    @Override
    public void enter() {
        PEVisiteAmap peVisiteAmap = (PEVisiteAmap)new ParametresService().loadParamEcran(MenuList.VISITE_AMAP);
        this.semaineViewer = GapViewerUtil.createGapWiever(peVisiteAmap.modeAffichage, () -> this.refresh(), (date, next) -> this.handleNextDate(date, next));
        this.addComponent((Component)this.semaineViewer.getComponent());
        VerticalLayout central = new VerticalLayout();
        this.addComponent((Component)central);
        this.mainVerticalLayout = new VerticalLayout();
        central.addComponent((Component)this.mainVerticalLayout);
        this.refresh();
    }

    private void refresh() {
        this.mainVerticalLayout.removeAllComponents();
        VisiteAmapDTO res = new VisiteAmapService().getAll(this.semaineViewer.getDateDebut(), this.semaineViewer.getDateFin(), SessionManager.getUserId());
        List<VisiteAmapDTO.Jour> jours = res.jours;
        int i = 0;
        while (i < jours.size()) {
            VisiteAmapDTO.Jour jour = jours.get(i);
            this.displayBlocDate(jour, i == 0);
            ++i;
        }
        this.endOfRefresh();
    }

    private void displayBlocDate(VisiteAmapDTO.Jour jour, boolean displayButtonCompactMode) {
        if (displayButtonCompactMode) {
            HorizontalLayout hl = new HorizontalLayout();
            hl.setMargin(false);
            hl.setSpacing(false);
            hl.setWidth("100%");
            Label l1 = BaseUiTools.addStdLabel((Layout)hl, this.df1.format(jour.dateLiv), "dateliv");
            hl.setExpandRatio((Component)l1, 1.0f);
            this.toggleButtonCompactMode = new Button("Vue compacte");
            this.toggleButtonCompactMode.addClickListener((Button.ClickListener & Serializable)e -> this.toggleCompactMode());
            this.updateCaptionOfButtonCompactMode();
            hl.addComponent((Component)this.toggleButtonCompactMode);
            this.mainVerticalLayout.addComponent((Component)hl);
        } else {
            BaseUiTools.addStdLabel((Layout)this.mainVerticalLayout, this.df1.format(jour.dateLiv), "dateliv");
        }
        for (VisiteAmapDTO.Producteur producteur : jour.producteurs) {
            this.displayBlocProducteur(producteur);
        }
    }

    private void toggleCompactMode() {
        this.compactMode = !this.compactMode;
        this.refresh();
    }

    private void updateCaptionOfButtonCompactMode() {
        if (this.compactMode) {
            this.toggleButtonCompactMode.setCaption("Vue d\u00e9taill\u00e9e");
        } else {
            this.toggleButtonCompactMode.setCaption("Vue compacte");
        }
    }

    private void displayBlocProducteur(VisiteAmapDTO.Producteur producteur) {
        VerticalLayout vl = BaseUiTools.addPanel((Layout)this.mainVerticalLayout, "unproducteur");
        if (!this.compactMode) {
            HorizontalLayout hl = new HorizontalLayout();
            hl.setWidth("100%");
            Label l = BaseUiTools.addStdLabel((Layout)hl, producteur.producteurNom, "nomproducteur");
            hl.setExpandRatio((Component)l, 1.0f);
            Button btn = new Button();
            btn.setIcon((Resource)FontAwesome.QUESTION_CIRCLE);
            btn.addStyleName("more-info");
            btn.addStyleName("question-mark");
            btn.addClickListener((Button.ClickListener & Serializable)e -> this.handleBtnInfo(producteur));
            hl.addComponent((Component)btn);
            vl.addComponent((Component)hl);
        }
        for (VisiteAmapDTO.Contrat contrat : producteur.contrats) {
            this.displayBlocContrat(contrat, vl, producteur.producteurNom);
        }
    }

    private void displayBlocContrat(VisiteAmapDTO.Contrat contrat, VerticalLayout vl, String producteurNom) {
        InscriptionButtonModule inscriptionButtonModule = new InscriptionButtonModule(() -> this.refresh());
        if (this.compactMode) {
            BaseUiTools.addBandeau((Layout)vl, String.valueOf(VisiteAmapView.s(producteurNom)) + " - " + VisiteAmapView.s(contrat.contratNom), "nomcontrat");
        } else {
            BaseUiTools.addBandeau((Layout)vl, VisiteAmapView.s(contrat.contratNom), "nomcontrat");
        }
        HorizontalLayout hl = new HorizontalLayout();
        hl.setMargin(true);
        hl.setSpacing(true);
        hl.setWidth("100%");
        hl.setStyleName("contrat-bloc");
        VerticalLayout vl1 = new VerticalLayout();
        if (!this.compactMode) {
            String propose = this.formatContratPropose(contrat);
            BaseUiTools.addHtmlLabel((Layout)vl1, propose, "ligproduit");
        }
        String contenuMonContrat = this.formatMonContrat(contrat);
        BaseUiTools.addHtmlLabel((Layout)vl1, contenuMonContrat, "ligproduit");
        hl.addComponent((Component)vl1);
        hl.setComponentAlignment((Component)vl1, Alignment.MIDDLE_RIGHT);
        hl.setExpandRatio((Component)vl1, 1.0f);
        if (contrat.contratDTO != null) {
            inscriptionButtonModule.buildBloc(hl, contrat.contratDTO);
        }
        vl.addComponent((Component)hl);
    }

    private String formatContratPropose(VisiteAmapDTO.Contrat contrat) {
        StringBuilder sb = new StringBuilder();
        sb.append("Ce contrat propose :<ul>");
        for (VisiteAmapDTO.LigneContrat lig : contrat.ligneContrats) {
            sb.append("<li>" + VisiteAmapView.s(lig.produitNom) + ", " + VisiteAmapView.s(lig.produitConditionnement) + " - Prix : " + FormatUtils.prix(lig.produitPrix) + "</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    private String formatMonContrat(VisiteAmapDTO.Contrat contrat) {
        SmallContratDTO m = contrat.contratDTO;
        if (m == null) {
            return "Vous ne pouvez plus vous inscrire en ligne sur ce contrat, contactez le r\u00e9f\u00e9rent.";
        }
        if (m.contratId == null) {
            if (m.inscriptionDTO.isRetardataire) {
                return "Vous n'etes pas inscrit sur ce contrat mais vous pouvez vous inscrire en tant que nouvel arrivant / retardataire";
            }
            return "Vous n'etes pas inscrit sur ce contrat";
        }
        List<QteProdDTO> qteProdDTOs = contrat.qteProdDTOs;
        if (qteProdDTOs.size() == 0) {
            return "Vous etes inscrit sur ce contrat mais vous n'avez rien pris ce jour l\u00e0.";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Vous etes inscrit sur ce contrat. Vous avez pris :<ul>");
        for (QteProdDTO lig : qteProdDTOs) {
            sb.append("<li>" + lig.qte + " " + VisiteAmapView.s(lig.nomProduit) + ", " + VisiteAmapView.s(lig.conditionnementProduit) + "</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    private void handleBtnInfo(VisiteAmapDTO.Producteur producteur) {
        new ProducteurPopupInfo(producteur).open();
    }

    private GenericUtils.Ret<Date> handleNextDate(Date date, boolean next) {
        Date d = new VisiteAmapService().provideNextDate(date, next);
        if (d == null) {
            return GenericUtils.Ret.error(next ? "Il n'y a pas de date de livraison suivante" : "Il n'y a pas de date de livraison pr\u00e9cedente");
        }
        return GenericUtils.Ret.ok(d);
    }
}

