/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereFrameworkInitializer;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;

public class AtmosphereServlet
extends HttpServlet {
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereServlet.class);
    protected final AtmosphereFrameworkInitializer initializer;
    protected AtmosphereFramework framework;
    protected boolean isFilter;
    protected boolean autoDetectHandlers;

    public AtmosphereServlet() {
        this(false);
    }

    public AtmosphereServlet(boolean isFilter) {
        this(isFilter, true);
    }

    public AtmosphereServlet(boolean isFilter, boolean autoDetectHandlers) {
        this.initializer = new AtmosphereFrameworkInitializer(isFilter, autoDetectHandlers);
        this.autoDetectHandlers = autoDetectHandlers;
        this.isFilter = isFilter;
    }

    public void destroy() {
        this.initializer.destroy();
    }

    public void init(ServletConfig sc) throws ServletException {
        this.configureFramework(sc);
        super.init(sc);
    }

    protected AtmosphereServlet configureFramework(ServletConfig sc) throws ServletException {
        return this.configureFramework(sc, true);
    }

    protected AtmosphereServlet configureFramework(ServletConfig sc, boolean init) throws ServletException {
        this.initializer.configureFramework(sc, init, false);
        this.framework = this.initializer.framework();
        return this;
    }

    protected AtmosphereFramework newAtmosphereFramework() {
        this.framework = this.initializer.newAtmosphereFramework();
        return this.framework;
    }

    public AtmosphereFramework framework() {
        return this.initializer.framework();
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.framework().doCometSupport(AtmosphereRequest.wrap(req), AtmosphereResponse.wrap(res));
    }
}

