/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.messagingcenter.miniproxy.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class BasicHttpDeserializer {
    private InputStream is;

    public BasicHttpDeserializer(InputStream is) {
        this.is = is;
    }

    public int readInt() throws IOException {
        byte[] bs = new byte[4];
        IOUtils.readFully((InputStream)this.is, (byte[])bs);
        return ByteBuffer.wrap(bs).getInt();
    }

    public long readLong() throws IOException {
        byte[] bs = new byte[8];
        IOUtils.readFully((InputStream)this.is, (byte[])bs);
        return ByteBuffer.wrap(bs).getLong();
    }

    public String readString() throws IOException {
        return this.readString(-1);
    }

    public String readString(int maxLen) throws IOException {
        int len = this.readInt();
        if (maxLen > 0 && len > maxLen) {
            throw new IOException("maxLen = " + maxLen + " Current len=" + len);
        }
        byte[] bs = new byte[len];
        IOUtils.readFully((InputStream)this.is, (byte[])bs);
        return new String(bs, "UTF-8");
    }

    public String readGzipString() throws IOException {
        int len = this.readInt();
        byte[] bs = new byte[len];
        IOUtils.readFully((InputStream)this.is, (byte[])bs);
        ByteArrayInputStream bais = new ByteArrayInputStream(bs);
        GZIPInputStream gis = new GZIPInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)gis, (OutputStream)baos);
        baos.close();
        gis.close();
        return new String(baos.toByteArray(), "UTF-8");
    }

    public FileInfo readFileAndCopyTo(File directory) throws IOException {
        FileInfo f = new FileInfo();
        f.fileName = this.readString();
        f.fileSize = this.readLong();
        File dest = new File(directory, f.fileName);
        FileOutputStream fos = new FileOutputStream(dest);
        byte[] bs = new byte[131072];
        IOUtils.copyLarge((InputStream)this.is, (OutputStream)fos, (long)0L, (long)f.fileSize, (byte[])bs);
        return f;
    }

    public static class FileInfo {
        public String fileName;
        public long fileSize;
    }
}

