/*
 *  Copyright 2013-2050 Emmanuel BRUN (contact@amapj.fr)
 * 
 *  This file is part of AmapJ.
 *  
 *  AmapJ is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.

 *  AmapJ is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with AmapJ.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 */
 package fr.amapj.common.periode;

import java.text.SimpleDateFormat;
import java.util.Date;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.FormatUtils;

public class PeriodeUtils 
{
	static public String getDescriptionPeriode(TypPeriode typPeriode,Date startDate,Date endDate)
	{
		switch (typPeriode)
		{
		case JOUR:
		{
			SimpleDateFormat df = FormatUtils.getFullDate();
			return "la journée du "+df.format(startDate);
		}
		case SEMAINE:
		{
			SimpleDateFormat df = FormatUtils.getFullDate();
			return "la semaine du "+df.format(startDate)+" au "+df.format(endDate);
		}
		
		case MOIS:
		{
			SimpleDateFormat df = FormatUtils.getMoisFullText();
			return "le mois de "+df.format(startDate);
		}
		
		case TRIMESTRE:
		{
			return "le trimestre de "+FormatUtils.formatTrimestreFullText(startDate);
		}
		
		case A_PARTIR_DE:
		{
			SimpleDateFormat df = FormatUtils.getFullDate();
			return "toutes les dates à partir du "+df.format(startDate);
		}	
		
		default:
			throw new AmapjRuntimeException();
		}
	}
}
