/*
 *  Copyright 2013-2050 Emmanuel BRUN (contact@amapj.fr)
 * 
 *  This file is part of AmapJ.
 *  
 *  AmapJ is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.

 *  AmapJ is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with AmapJ.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 */
 package fr.amapj.model.models.fichierbase;

import fr.amapj.model.engine.metadata.MetaDataEnum;

/**
 * Mode de gestion des stocks pour ce prodcuteur 
 */
public enum ProducteurNotificationRetardataire
{
	// 
	NO,
	
	//  
	REFERENT,
	
	//
	REFERENT_PRODUCTEUR;
	
	
	static public class MetaData extends MetaDataEnum
	{
		public void fill()
		{		
			add("Ce champ vous permet d'activer ou de désactiver l'envoi d'un mail de notification quand un contrat de type nouvel arrivant / retardataire a été saisi par un amapien");

			add(NO, "Pas de notification" , "Aucun mail n'est envoyé quand un amapien s'inscrit en tant que retardataire");
			
			add(REFERENT, "Notification des référents","Un mail est envoyé aux référents");
			
			add(REFERENT_PRODUCTEUR, "Notification des référents et des producteurs","Un mail est envoyé aux référents et aux producteurs");
			
			addBrLink("Gestion des nouveaux arrivants / retardataires", "docs_utilisateur_nouveaux_arrivants.html");
		}
	}		
}
