/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.messagingcenter.miniproxy.model.mailer;

import fr.amapj.messagingcenter.miniproxy.model.mailer.RemoteMailerAttachement;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public class RemoteMailerMessage {
    public String fromAddress;
    public String fromPersonalName;
    public String recipentsTo;
    public String recipentsCc;
    public String recipentsBcc;
    public String title;
    public String htmlContent;
    public List<RemoteMailerAttachement> attachements = new ArrayList<RemoteMailerAttachement>();

    public void addAttachement(RemoteMailerAttachement attachement) {
        this.attachements.add(attachement);
    }

    public void fillMessage(Message message) throws UnsupportedEncodingException, MessagingException {
        message.setFrom((Address)new InternetAddress(this.fromAddress, this.fromPersonalName));
        if (this.recipentsTo != null) {
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.recipentsTo));
        }
        if (this.recipentsCc != null) {
            message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.recipentsCc));
        }
        if (this.recipentsBcc != null) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)this.recipentsBcc));
        }
        message.setSubject(this.title);
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart htmlPart = new MimeBodyPart();
        htmlPart.setText(this.htmlContent, "UTF-8", "html");
        mp.addBodyPart((BodyPart)htmlPart);
        for (RemoteMailerAttachement attachement : this.attachements) {
            MimeBodyPart attachment = new MimeBodyPart();
            attachment.setFileName(attachement.name);
            attachment.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(attachement.data, attachement.contentType)));
            mp.addBodyPart((BodyPart)attachment);
        }
        message.setContent((Multipart)mp);
    }
}

