/*
 *  Copyright 2013-2050 Emmanuel BRUN (contact@amapj.fr)
 * 
 *  This file is part of AmapJ.
 *  
 *  AmapJ is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.

 *  AmapJ is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with AmapJ.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 */
 package fr.amapj.view.views.login.passwordrecovery;

import fr.amapj.service.services.authentification.PasswordManager;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.genericmodel.StringItem;

/**
 * Popup pour la saisie de la nouvelle adresse e mail
 *  
 */
public class PopupSaisieEmailForPasswordRecovery extends WizardFormPopup
{
	private StringItem dto;

	/**
	 * 
	 */
	public PopupSaisieEmailForPasswordRecovery()
	{
		popupTitle = "Perte de mot de passe";
		
		dto = new StringItem();
		setModel(dto);
	}
	
	@Override
	protected void configure()
	{
		add(()->addSaisieEmail());
		add(()->addResultat());
	}
	
	
	protected void addSaisieEmail()
	{
		addHtml(	"Si vous avez perdu votre mot de passe, <br/>" +
					"merci de saisir votre adresse e mail ci dessous.<br/><br/>" +
					"Vous recevrez dans quelques minutes un mail qui <br/>" +
					"vous permettra de réinitialiser votre mot de passe.<br/><br/>");
		
		addTextField("Votre e-mail", "value");
		
		
		
	}

	protected void addResultat() 
	{
		String email = dto.value;
		String msg = new PasswordManager().sendMailForResetPassword(email);
		if (msg==null)
		{
			msg = "Un mail vient de vous être envoyé. Merci de vérifier votre boîte mail";
		}
		addHtml(msg);
		
		setAllButtonsAsOK();
	}
	
	@Override
	protected void performSauvegarder() 
	{
		
	}


	
}
