/*
 *  Copyright 2013-2050 Emmanuel BRUN (contact@amapj.fr)
 * 
 *  This file is part of AmapJ.
 *  
 *  AmapJ is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.

 *  AmapJ is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with AmapJ.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 */
 package fr.amapj.view.views.saisiecontrat.step2paiement;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;

import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.saisiecontrat.SaisieContrat.ModeSaisie;
import fr.amapj.view.views.saisiecontrat.SaisieContrat.SaisieContratData;

/**
 * Ce popup demande au référent si il souhaite modifier les paiements 
 * tout de suite ou plus tard 
 */
public class PopupChoixSaisiePaiement extends CorePopup
{
	private VerticalLayout contentLayout;
	private SaisieContratData data;

	/**
	 * 
	 */
	public PopupChoixSaisiePaiement(SaisieContratData data)
	{
		this.data = data;
		popupTitle = "Modifier les paiements maintenant ?";	
	}
	
	protected void createButtonBar()
	{	
		addButton("Modifier les paiements plus tard", e->close());
		addButtonBlank();
		addDefaultButton("Modifier les paiements maintenant", e->handleModifierMaintenant());					
	}
	
	private void handleModifierMaintenant() 
	{
		// A noter : on ouvre complétement un nouveau cycle de saisie 
		Long idModeleContrat = data.contratDTO.modeleContratId;
		Long idContrat = data.contratDTO.contratId;
		Long userId = data.userId;
		String messageSpecifique = data.messageSpecifique;
		PopupListener listener = data.listener; 
		
		SaisieContrat.saisieContrat(idModeleContrat,idContrat,userId,messageSpecifique,ModeSaisie.CHEQUE_SEUL,listener);
		
		close();
	}

	@Override
	protected void createContent(VerticalLayout contentLayout) 
	{
		this.contentLayout = contentLayout;
		
		addHtml("La modification des quantités a bien été enregistrée.<br/><br/>");
		
		if (data.inscriptionDTO.onLoadPaiementEqualCommande)
		{
			addHtml("Néanmoins, cette modification a généré un écart entre les paiements et le montant commandé.<br/><br/>");
		}
		else
		{
			addHtml("Néanmoins, il y a un écart entre les paiements et le montant commandé (écart qui existait déjà avant votre modification).<br/><br/>");
		}
		
		addHtml("Que souhaitez vous faire ?");		
	}

	private void addHtml(String str) 
	{
		contentLayout.addComponent(new Label(str,ContentMode.HTML));	
	}	
}

